/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.display.GlobalTrainDisplayData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ChangeThrottleInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ChangeTitleInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ScheduleRuntime {
    Train train;
    Schedule schedule;
    public boolean isAutoSchedule;
    public boolean paused;
    public boolean completed;
    public int currentEntry;
    public State state;
    static final int INTERVAL = 40;
    int cooldown;
    List<Integer> conditionProgress;
    List<CompoundTag> conditionContext;
    String currentTitle;
    int ticksInTransit;
    List<Integer> predictionTicks;
    public boolean displayLinkUpdateRequested;

    public ScheduleRuntime(Train train) {
        this.train = train;
        this.reset();
    }

    public void destinationReached() {
        if (this.state != State.IN_TRANSIT) {
            return;
        }
        this.state = State.POST_TRANSIT;
        this.conditionProgress.clear();
        this.displayLinkUpdateRequested = true;
        for (Carriage carriage : this.train.carriages) {
            carriage.storage.resetIdleCargoTracker();
        }
        if (this.ticksInTransit > 0) {
            int current = this.predictionTicks.get(this.currentEntry);
            if (current > 0) {
                this.ticksInTransit = (current + this.ticksInTransit) / 2;
            }
            this.predictionTicks.set(this.currentEntry, this.ticksInTransit);
        }
        if (this.currentEntry >= this.schedule.entries.size()) {
            return;
        }
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        for (int i = 0; i < conditions.size(); ++i) {
            this.conditionProgress.add(0);
            this.conditionContext.add(new CompoundTag());
        }
    }

    public void transitInterrupted() {
        if (this.schedule == null || this.state != State.IN_TRANSIT) {
            return;
        }
        this.state = State.PRE_TRANSIT;
        this.cooldown = 0;
    }

    public void tick(Level level) {
        if (this.schedule == null) {
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.train.derailed) {
            return;
        }
        if (this.train.navigation.destination != null) {
            ++this.ticksInTransit;
            return;
        }
        if (this.currentEntry >= this.schedule.entries.size()) {
            this.currentEntry = 0;
            if (!this.schedule.cyclic) {
                this.paused = true;
                this.completed = true;
            }
            return;
        }
        if (this.cooldown-- > 0) {
            return;
        }
        if (this.state == State.IN_TRANSIT) {
            return;
        }
        if (this.state == State.POST_TRANSIT) {
            this.tickConditions(level);
            return;
        }
        GlobalStation nextStation = this.startCurrentInstruction();
        if (nextStation == null) {
            return;
        }
        this.train.status.successfulNavigation();
        if (nextStation == this.train.getCurrentStation()) {
            this.state = State.IN_TRANSIT;
            this.destinationReached();
            return;
        }
        if (this.train.navigation.startNavigation(nextStation, Double.MAX_VALUE, false) != -1.0) {
            this.state = State.IN_TRANSIT;
            this.ticksInTransit = 0;
        }
    }

    public void tickConditions(Level level) {
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        for (int i = 0; i < conditions.size(); ++i) {
            List<ScheduleWaitCondition> list = conditions.get(i);
            int progress = this.conditionProgress.get(i);
            if (progress >= list.size()) {
                this.state = State.PRE_TRANSIT;
                ++this.currentEntry;
                return;
            }
            CompoundTag tag = this.conditionContext.get(i);
            ScheduleWaitCondition condition = list.get(progress);
            int prevVersion = tag.m_128451_("StatusVersion");
            if (condition.tickCompletion(level, this.train, tag)) {
                this.conditionContext.set(i, new CompoundTag());
                this.conditionProgress.set(i, progress + 1);
                this.displayLinkUpdateRequested |= i == 0;
            }
            this.displayLinkUpdateRequested |= i == 0 && prevVersion != tag.m_128451_("StatusVersion");
        }
        for (Carriage carriage : this.train.carriages) {
            carriage.storage.tickIdleCargoTracker();
        }
    }

    public GlobalStation startCurrentInstruction() {
        ScheduleEntry entry = this.schedule.entries.get(this.currentEntry);
        ScheduleInstruction instruction = entry.instruction;
        if (instruction instanceof DestinationInstruction) {
            DestinationInstruction destination = (DestinationInstruction)instruction;
            String regex = destination.getFilterForRegex();
            GlobalStation best = null;
            double bestCost = Double.MAX_VALUE;
            boolean anyMatch = false;
            if (!this.train.hasForwardConductor() && !this.train.hasBackwardConductor()) {
                this.train.status.missingConductor();
                this.cooldown = 40;
                return null;
            }
            for (GlobalStation globalStation : this.train.graph.getPoints(EdgePointType.STATION)) {
                if (!globalStation.name.matches(regex)) continue;
                anyMatch = true;
                boolean matchesCurrent = this.train.currentStation != null && this.train.currentStation.equals(globalStation.id);
                double cost = matchesCurrent ? 0.0 : this.train.navigation.startNavigation(globalStation, bestCost, true);
                if (cost < 0.0 || cost > bestCost) continue;
                best = globalStation;
                bestCost = cost;
            }
            if (best == null) {
                if (anyMatch) {
                    this.train.status.failedNavigation();
                } else {
                    this.train.status.failedNavigationNoTarget(destination.getFilter());
                }
                this.cooldown = 40;
                return null;
            }
            return best;
        }
        if (instruction instanceof ChangeTitleInstruction) {
            ChangeTitleInstruction title = (ChangeTitleInstruction)instruction;
            this.currentTitle = title.getScheduleTitle();
            this.state = State.PRE_TRANSIT;
            ++this.currentEntry;
            return null;
        }
        if (instruction instanceof ChangeThrottleInstruction) {
            ChangeThrottleInstruction throttle = (ChangeThrottleInstruction)instruction;
            this.train.throttle = throttle.getThrottle();
            this.state = State.PRE_TRANSIT;
            ++this.currentEntry;
            return null;
        }
        return null;
    }

    public void setSchedule(Schedule schedule, boolean auto) {
        this.reset();
        this.schedule = schedule;
        this.currentEntry = Mth.m_14045_((int)schedule.savedProgress, (int)0, (int)(schedule.entries.size() - 1));
        this.paused = false;
        this.isAutoSchedule = auto;
        this.train.status.newSchedule();
        this.predictionTicks = new ArrayList<Integer>();
        schedule.entries.forEach($ -> this.predictionTicks.add(-1));
        this.displayLinkUpdateRequested = true;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void discardSchedule() {
        this.train.navigation.cancelNavigation();
        this.reset();
    }

    private void reset() {
        this.paused = true;
        this.completed = false;
        this.isAutoSchedule = false;
        this.currentEntry = 0;
        this.currentTitle = "";
        this.schedule = null;
        this.state = State.PRE_TRANSIT;
        this.conditionProgress = new ArrayList<Integer>();
        this.conditionContext = new ArrayList<CompoundTag>();
        this.predictionTicks = new ArrayList<Integer>();
    }

    public Collection<GlobalTrainDisplayData.TrainDeparturePrediction> submitPredictions() {
        int index;
        ArrayList<GlobalTrainDisplayData.TrainDeparturePrediction> predictions = new ArrayList<GlobalTrainDisplayData.TrainDeparturePrediction>();
        int entryCount = this.schedule.entries.size();
        int accumulatedTime = 0;
        int current = this.currentEntry;
        if (this.state == State.POST_TRANSIT || current >= entryCount) {
            int departureTime;
            GlobalStation currentStation = this.train.getCurrentStation();
            if (currentStation != null) {
                predictions.add(this.createPrediction(current, currentStation.name, this.currentTitle, 0));
            }
            if ((departureTime = this.estimateStayDuration(current)) == -1) {
                accumulatedTime = -1;
            }
        } else {
            GlobalStation destination = this.train.navigation.destination;
            if (destination != null) {
                float predictedTime;
                double speed = Math.min(this.train.throttle * (double)this.train.maxSpeed(), (double)((this.train.maxSpeed() + this.train.maxTurnSpeed()) / 2.0f));
                int timeRemaining = (int)(this.train.navigation.distanceToDestination / speed) * 2;
                if (this.predictionTicks.size() > current && this.train.navigation.distanceStartedAt != 0.0 && (predictedTime = (float)this.predictionTicks.get(current).intValue()) > 0.0f) {
                    predictedTime = (float)((double)predictedTime * Mth.m_14008_((double)(this.train.navigation.distanceToDestination / this.train.navigation.distanceStartedAt), (double)0.0, (double)1.0));
                    timeRemaining = (timeRemaining + (int)predictedTime) / 2;
                }
                predictions.add(this.createPrediction(current, destination.name, this.currentTitle, accumulatedTime += timeRemaining));
                int departureTime = this.estimateStayDuration(current);
                if (departureTime != -1) {
                    accumulatedTime += departureTime;
                }
                if (departureTime == -1) {
                    accumulatedTime = -1;
                }
            } else {
                this.predictForEntry(current, this.currentTitle, accumulatedTime, predictions);
            }
        }
        String currentTitle = this.currentTitle;
        for (int i = 1; i < entryCount && ((index = (i + current) % entryCount) != 0 || this.schedule.cyclic); ++i) {
            ScheduleInstruction scheduleInstruction = this.schedule.entries.get((int)index).instruction;
            if (scheduleInstruction instanceof ChangeTitleInstruction) {
                ChangeTitleInstruction title = (ChangeTitleInstruction)scheduleInstruction;
                currentTitle = title.getScheduleTitle();
                continue;
            }
            accumulatedTime = this.predictForEntry(index, currentTitle, accumulatedTime, predictions);
        }
        predictions.removeIf(Objects::isNull);
        return predictions;
    }

    private int predictForEntry(int index, String currentTitle, int accumulatedTime, Collection<GlobalTrainDisplayData.TrainDeparturePrediction> predictions) {
        ScheduleEntry entry = this.schedule.entries.get(index);
        ScheduleInstruction scheduleInstruction = entry.instruction;
        if (!(scheduleInstruction instanceof DestinationInstruction)) {
            return accumulatedTime;
        }
        DestinationInstruction filter = (DestinationInstruction)scheduleInstruction;
        if (this.predictionTicks.size() <= this.currentEntry) {
            return accumulatedTime;
        }
        if (accumulatedTime == -1) {
            predictions.add(this.createPrediction(index, filter.getFilter(), currentTitle, accumulatedTime));
            return -1;
        }
        int predictedTime = this.predictionTicks.get(index);
        int departureTime = this.estimateStayDuration(index);
        if (predictedTime == -1) {
            accumulatedTime = -1;
        } else {
            accumulatedTime += predictedTime;
            if (departureTime != -1) {
                accumulatedTime += departureTime;
            }
        }
        predictions.add(this.createPrediction(index, filter.getFilter(), currentTitle, accumulatedTime));
        if (departureTime == -1) {
            return -1;
        }
        return accumulatedTime;
    }

    private int estimateStayDuration(int index) {
        if (index >= this.schedule.entries.size()) {
            if (!this.schedule.cyclic) {
                return 100000;
            }
            index = 0;
        }
        ScheduleEntry scheduleEntry = this.schedule.entries.get(index);
        for (List<ScheduleWaitCondition> list : scheduleEntry.conditions) {
            for (ScheduleWaitCondition condition : list) {
                if (!(condition instanceof ScheduledDelay)) continue;
                ScheduledDelay wait = (ScheduledDelay)condition;
                return wait.totalWaitTicks();
            }
        }
        return 5;
    }

    private GlobalTrainDisplayData.TrainDeparturePrediction createPrediction(int index, String destination, String currentTitle, int time) {
        String text;
        int size = this.schedule.entries.size();
        if (index >= size) {
            if (!this.schedule.cyclic) {
                return new GlobalTrainDisplayData.TrainDeparturePrediction(this.train, time, Components.literal(" "), destination);
            }
            index %= size;
        }
        if ((text = currentTitle).isBlank()) {
            for (int i = 1; i < size; ++i) {
                int j = (index + i) % size;
                ScheduleEntry scheduleEntry = this.schedule.entries.get(j);
                ScheduleInstruction scheduleInstruction = scheduleEntry.instruction;
                if (!(scheduleInstruction instanceof DestinationInstruction)) continue;
                DestinationInstruction instruction = (DestinationInstruction)scheduleInstruction;
                text = instruction.getFilter().replaceAll("\\*", "").trim();
                break;
            }
        }
        return new GlobalTrainDisplayData.TrainDeparturePrediction(this.train, time, Components.literal(text), destination);
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("CurrentEntry", this.currentEntry);
        tag.m_128379_("AutoSchedule", this.isAutoSchedule);
        tag.m_128379_("Paused", this.paused);
        tag.m_128379_("Completed", this.completed);
        if (this.schedule != null) {
            tag.m_128365_("Schedule", (Tag)this.schedule.write());
        }
        NBTHelper.writeEnum(tag, "State", this.state);
        tag.m_128408_("ConditionProgress", this.conditionProgress);
        tag.m_128365_("ConditionContext", (Tag)NBTHelper.writeCompoundList(this.conditionContext, CompoundTag::m_6426_));
        tag.m_128408_("TransitTimes", this.predictionTicks);
        return tag;
    }

    public void read(CompoundTag tag) {
        this.reset();
        this.paused = tag.m_128471_("Paused");
        this.completed = tag.m_128471_("Completed");
        this.isAutoSchedule = tag.m_128471_("AutoSchedule");
        this.currentEntry = tag.m_128451_("CurrentEntry");
        if (tag.m_128441_("Schedule")) {
            this.schedule = Schedule.fromTag(tag.m_128469_("Schedule"));
        }
        this.state = NBTHelper.readEnum(tag, "State", State.class);
        for (int i : tag.m_128465_("ConditionProgress")) {
            this.conditionProgress.add(i);
        }
        NBTHelper.iterateCompoundList(tag.m_128437_("ConditionContext", 10), this.conditionContext::add);
        int[] readTransits = tag.m_128465_("TransitTimes");
        if (this.schedule != null) {
            this.schedule.entries.forEach($ -> this.predictionTicks.add(-1));
            if (readTransits.length == this.schedule.entries.size()) {
                for (int i = 0; i < readTransits.length; ++i) {
                    this.predictionTicks.set(i, readTransits[i]);
                }
            }
        }
    }

    public ItemStack returnSchedule() {
        if (this.schedule == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = AllItems.SCHEDULE.asStack();
        CompoundTag nbt = stack.m_41784_();
        this.schedule.savedProgress = this.currentEntry;
        nbt.m_128365_("Schedule", (Tag)this.schedule.write());
        stack = this.isAutoSchedule ? ItemStack.f_41583_ : stack;
        this.discardSchedule();
        return stack;
    }

    public void setSchedulePresentClientside(boolean present) {
        this.schedule = present ? new Schedule() : null;
    }

    public MutableComponent getWaitingStatus(Level level) {
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        if (conditions.isEmpty() || this.conditionProgress.isEmpty() || this.conditionContext.isEmpty()) {
            return Components.empty();
        }
        List<ScheduleWaitCondition> list = conditions.get(0);
        int progress = this.conditionProgress.get(0);
        if (progress >= list.size()) {
            return Components.empty();
        }
        CompoundTag tag = this.conditionContext.get(0);
        ScheduleWaitCondition condition = list.get(progress);
        return condition.getWaitingStatus(level, this.train, tag);
    }

    public static enum State {
        PRE_TRANSIT,
        IN_TRANSIT,
        POST_TRANSIT;

    }
}

