/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.ponder.ui.PonderTagScreen;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PonderTagIndexScreen
extends NavigatableSimiScreen {
    public static final String EXIT = "ponder.exit";
    public static final String TITLE = "ponder.index_title";
    public static final String WELCOME = "ponder.welcome";
    public static final String CATEGORIES = "ponder.categories";
    public static final String DESCRIPTION = "ponder.index_description";
    private final double itemXmult = 0.5;
    protected Rect2i itemArea;
    protected Rect2i chapterArea;
    private final double mainYmult = 0.15;
    private PonderTag hoveredItem = null;

    @Override
    protected void m_7856_() {
        super.m_7856_();
        List<PonderTag> tags = PonderRegistry.TAGS.getListedTags();
        int rowCount = Mth.m_14045_((int)((int)Math.ceil((double)tags.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(tags.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.f_96543_ * 0.5);
        int itemCenterY = this.getItemsY();
        for (PonderTag i : tags) {
            PonderButton b = (PonderButton)((AbstractSimiWidget)new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showingTag(i)).withCallback((mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(new PonderTagScreen(i));
            });
            this.m_142416_(b);
            layout.next();
        }
        this.backTrack = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(31, this.f_96544_ - 31 - 20).enableFade(0, 5)).showing(AllIcons.I_MTD_CLOSE)).withCallback(() -> ScreenOpener.openPreviousScreen(this, Optional.empty()));
        this.m_142416_(this.backTrack);
        this.backTrack.fade(1.0f);
    }

    @Override
    protected void initBackTrackIcon(PonderButton backTrack) {
        backTrack.showing(AllItems.WRENCH.asStack());
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = null;
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        for (GuiEventListener child : this.m_6702_()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).m_5953_(mouseX, mouseY)) continue;
            this.hoveredItem = button.getTag();
        }
    }

    @Override
    protected String backTrackingLangKey() {
        return EXIT;
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.renderItems(ms, mouseX, mouseY, partialTicks);
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2 - 120), (double)this.f_96544_ * 0.15 - 40.0, 0.0);
        ms.m_85836_();
        int x = 59;
        int y = 31;
        String title = Lang.translateDirect(WELCOME, new Object[0]).getString();
        int streakHeight = 35;
        UIRenderHelper.streak(ms, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(21.0f, 21.0f, 100.0f)).withBounds(30, 30)).render(ms);
        this.f_96547_.m_92883_(ms, title, (float)(x + 8), (float)(y + 1), Theme.i(Theme.Key.TEXT));
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85837_(23.0, 23.0, 10.0);
        ms.m_85841_(1.66f, 1.66f, 1.66f);
        ms.m_85837_(-4.0, -4.0, 0.0);
        ms.m_85841_(1.5f, 1.5f, 1.5f);
        GuiGameElement.of(AllItems.WRENCH.asStack()).render(ms);
        ms.m_85849_();
        ms.m_85849_();
        ms.m_85836_();
        int w = (int)((double)this.f_96543_ * 0.45);
        x = (this.f_96543_ - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.m_110091_(), 48);
        String desc = Lang.translateDirect(DESCRIPTION, new Object[0]).getString();
        int h = this.f_96547_.m_92920_(desc, w);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(x - 3, y - 3, 90.0f)).withBounds(w + 6, h + 6)).render(ms);
        ms.m_85837_(0.0, 0.0, 100.0);
        FontHelper.drawSplitString(ms, this.f_96547_, desc, x, y, w, Theme.i(Theme.Key.TEXT));
        ms.m_85849_();
    }

    protected void renderItems(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        List<PonderTag> tags = PonderRegistry.TAGS.getListedTags();
        if (tags.isEmpty()) {
            return;
        }
        int x = (int)((double)this.f_96543_ * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Lang.translateDirect(CATEGORIES, new Object[0]).getString();
        int stringWidth = this.f_96547_.m_92895_(relatedTitle);
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 0.0);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at((float)(this.windowWidth - stringWidth) / 2.0f - 5.0f, this.itemArea.m_110086_() - 21, 100.0f)).withBounds(stringWidth + 10, 10)).render(ms);
        ms.m_85837_(0.0, 0.0, 200.0);
        PonderTagIndexScreen.m_93208_((PoseStack)ms, (Font)this.f_96547_, (String)relatedTitle, (int)(this.windowWidth / 2), (int)(this.itemArea.m_110086_() - 20), (int)Theme.i(Theme.Key.TEXT));
        ms.m_85837_(0.0, 0.0, -200.0);
        UIRenderHelper.streak(ms, 0.0f, 0, 0, this.itemArea.m_110091_() + 10, this.itemArea.m_110090_() / 2 + 75);
        UIRenderHelper.streak(ms, 180.0f, 0, 0, this.itemArea.m_110091_() + 10, this.itemArea.m_110090_() / 2 + 75);
        ms.m_85849_();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.f_96544_ + 85.0);
    }

    @Override
    protected void renderWindowForeground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69465_();
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 200.0);
        if (this.hoveredItem != null) {
            List<Component> list = TooltipHelper.cutStringTextComponent(this.hoveredItem.getDescription(), ChatFormatting.GRAY, ChatFormatting.GRAY);
            list.add(0, (Component)Components.literal(this.hoveredItem.getTitle()));
            this.m_96597_(ms, list, mouseX, mouseY);
        }
        ms.m_85849_();
        RenderSystem.m_69482_();
    }

    @Override
    protected String getBreadcrumbTitle() {
        return Lang.translateDirect(TITLE, new Object[0]).getString();
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public void m_7861_() {
        super.m_7861_();
        this.hoveredItem = null;
    }
}

