/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import java.util.Collection;
import java.util.stream.Stream;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.recipes.FocusGroup;
import mezz.jei.recipes.RecipeManagerInternal;

public class RecipeLookup<R>
implements IRecipeLookup<R> {
    private final RecipeType<R> recipeType;
    private final RecipeManagerInternal recipeManager;
    private boolean includeHidden = false;
    private IFocusGroup focusGroup = FocusGroup.EMPTY;

    public RecipeLookup(RecipeType<R> recipeType, RecipeManagerInternal recipeManager) {
        this.recipeType = recipeType;
        this.recipeManager = recipeManager;
    }

    @Override
    public IRecipeLookup<R> limitFocus(Collection<? extends IFocus<?>> focuses) {
        this.focusGroup = FocusGroup.create(focuses);
        return this;
    }

    @Override
    public IRecipeLookup<R> includeHidden() {
        this.includeHidden = true;
        return this;
    }

    @Override
    public Stream<R> get() {
        return this.recipeManager.getRecipesStream(this.recipeType, this.focusGroup, this.includeHidden);
    }
}

