/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.ConsString;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ContextAction;
import dev.latvian.mods.rhino.DefiningClassLoader;
import dev.latvian.mods.rhino.GeneratedClassLoader;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.util.CustomJavaToJsWrapperProvider;
import dev.latvian.mods.rhino.util.CustomJavaToJsWrapperProviderHolder;
import dev.latvian.mods.rhino.util.DefaultRemapper;
import dev.latvian.mods.rhino.util.Remapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ContextFactory {
    private static final ContextFactory global = new ContextFactory();
    private volatile boolean sealed;
    private final Object listenersLock = new Object();
    private volatile Object listeners;
    private boolean disabledListening;
    TypeWrappers typeWrappers;
    Remapper remapper = DefaultRemapper.INSTANCE;
    final List<CustomJavaToJsWrapperProviderHolder<?>> customScriptableWrappers = new ArrayList();
    final Map<Class<?>, CustomJavaToJsWrapperProvider> customScriptableWrapperCache = new HashMap();
    private final Map<String, Object> extraProperties = new HashMap<String, Object>();

    public static ContextFactory getGlobal() {
        return global;
    }

    protected Context makeContext() {
        return new Context(this);
    }

    protected boolean hasFeature(Context cx, int featureIndex) {
        return switch (featureIndex) {
            case 2 -> false;
            case 3 -> true;
            case 5 -> true;
            case 7 -> false;
            case 8 -> false;
            case 9 -> false;
            case 10 -> false;
            case 11 -> false;
            case 12 -> false;
            case 13 -> false;
            case 14 -> true;
            case 17 -> false;
            case 18 -> false;
            case 19 -> false;
            default -> throw new IllegalArgumentException(String.valueOf(featureIndex));
        };
    }

    protected GeneratedClassLoader createClassLoader(ClassLoader parent) {
        return new DefiningClassLoader(parent);
    }

    public final ClassLoader getApplicationClassLoader() {
        return null;
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object result = callable.call(cx, scope, thisObj, args);
        return result instanceof ConsString ? result.toString() : result;
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
    }

    protected void onContextCreated(Context cx) {
        Listener l;
        Object listeners = this.listeners;
        int i = 0;
        while ((l = (Listener)Kit.getListener(listeners, i)) != null) {
            l.contextCreated(cx);
            ++i;
        }
    }

    protected void onContextReleased(Context cx) {
        Listener l;
        Object listeners = this.listeners;
        int i = 0;
        while ((l = (Listener)Kit.getListener(listeners, i)) != null) {
            l.contextReleased(cx);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Listener listener) {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.disabledListening) {
                throw new IllegalStateException();
            }
            this.listeners = Kit.addListener(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(Listener listener) {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.disabledListening) {
                throw new IllegalStateException();
            }
            this.listeners = Kit.removeListener(this.listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disableContextListening() {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            this.disabledListening = true;
            this.listeners = null;
        }
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal() {
        this.checkNotSealed();
        this.sealed = true;
    }

    protected final void checkNotSealed() {
        if (this.sealed) {
            throw new IllegalStateException();
        }
    }

    public final <T> T call(ContextAction<T> action) {
        return Context.call(this, action);
    }

    public Context enterContext() {
        return this.enterContext(null);
    }

    public final Context enterContext(Context cx) {
        return Context.enter(cx, this);
    }

    public void setExtraProperty(String key, @Nullable Object value) {
        if (value == null) {
            this.extraProperties.remove(key);
        } else {
            this.extraProperties.put(key, value);
        }
    }

    @Nullable
    public Object getExtraProperty(String key) {
        return this.extraProperties.get(key);
    }

    public static interface Listener {
        public void contextCreated(Context var1);

        public void contextReleased(Context var1);
    }
}

