/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.DToA;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.MemberType;
import dev.latvian.mods.rhino.NativeGlobal;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Undefined;

final class NativeNumber
extends IdScriptableObject {
    private static final long serialVersionUID = 3504516769741512101L;
    public static final double MAX_SAFE_INTEGER = 9.007199254740991E15;
    private static final Object NUMBER_TAG = "Number";
    private static final int MAX_PRECISION = 100;
    private static final double MIN_SAFE_INTEGER = -9.007199254740991E15;
    private static final int ConstructorId_isFinite = -1;
    private static final int ConstructorId_isNaN = -2;
    private static final int ConstructorId_isInteger = -3;
    private static final int ConstructorId_isSafeInteger = -4;
    private static final int ConstructorId_parseFloat = -5;
    private static final int ConstructorId_parseInt = -6;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_valueOf = 5;
    private static final int Id_toFixed = 6;
    private static final int Id_toExponential = 7;
    private static final int Id_toPrecision = 8;
    private static final int MAX_PROTOTYPE_ID = 8;
    private final double doubleValue;

    static void init(Scriptable scope, boolean sealed) {
        NativeNumber obj = new NativeNumber(0.0);
        obj.exportAsJSClass(8, scope, sealed);
    }

    NativeNumber(double number) {
        this.doubleValue = number;
    }

    @Override
    public String getClassName() {
        return "Number";
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        int attr = 7;
        ctor.defineProperty("NaN", (Object)ScriptRuntime.NaNobj, 7);
        ctor.defineProperty("POSITIVE_INFINITY", (Object)ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        ctor.defineProperty("NEGATIVE_INFINITY", (Object)ScriptRuntime.wrapNumber(Double.NEGATIVE_INFINITY), 7);
        ctor.defineProperty("MAX_VALUE", (Object)ScriptRuntime.wrapNumber(Double.MAX_VALUE), 7);
        ctor.defineProperty("MIN_VALUE", (Object)ScriptRuntime.wrapNumber(Double.MIN_VALUE), 7);
        ctor.defineProperty("MAX_SAFE_INTEGER", (Object)ScriptRuntime.wrapNumber(9.007199254740991E15), 7);
        ctor.defineProperty("MIN_SAFE_INTEGER", (Object)ScriptRuntime.wrapNumber(-9.007199254740991E15), 7);
        this.addIdFunctionProperty(ctor, NUMBER_TAG, -1, "isFinite", 1);
        this.addIdFunctionProperty(ctor, NUMBER_TAG, -2, "isNaN", 1);
        this.addIdFunctionProperty(ctor, NUMBER_TAG, -3, "isInteger", 1);
        this.addIdFunctionProperty(ctor, NUMBER_TAG, -4, "isSafeInteger", 1);
        this.addIdFunctionProperty(ctor, NUMBER_TAG, -5, "parseFloat", 1);
        this.addIdFunctionProperty(ctor, NUMBER_TAG, -6, "parseInt", 1);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected void initPrototypeId(int id) {
        int arity;
        this.initPrototypeMethod(NUMBER_TAG, id, switch (id) {
            case 1 -> {
                arity = 1;
                yield "constructor";
            }
            case 2 -> {
                arity = 1;
                yield "toString";
            }
            case 3 -> {
                arity = 1;
                yield "toLocaleString";
            }
            case 4 -> {
                arity = 0;
                yield "toSource";
            }
            case 5 -> {
                arity = 0;
                yield "valueOf";
            }
            case 6 -> {
                arity = 1;
                yield "toFixed";
            }
            case 7 -> {
                arity = 1;
                yield "toExponential";
            }
            case 8 -> {
                arity = 1;
                yield "toPrecision";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(NUMBER_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        if (id == 1) {
            double val;
            double d = val = args.length >= 1 ? ScriptRuntime.toNumber(args[0]) : 0.0;
            if (thisObj == null) {
                return new NativeNumber(val);
            }
            return ScriptRuntime.wrapNumber(val);
        }
        if (id < 1) {
            return NativeNumber.execConstructorCall(id, args);
        }
        if (!(thisObj instanceof NativeNumber)) {
            throw NativeNumber.incompatibleCallError(f);
        }
        double value = ((NativeNumber)thisObj).doubleValue;
        switch (id) {
            case 2: 
            case 3: {
                int base = args.length == 0 || args[0] == Undefined.instance ? 10 : ScriptRuntime.toInt32(args[0]);
                return ScriptRuntime.numberToString(value, base);
            }
            case 4: {
                return "not_supported";
            }
            case 5: {
                return ScriptRuntime.wrapNumber(value);
            }
            case 6: {
                return NativeNumber.num_to(value, args, 2, 2, 0, 0);
            }
            case 7: {
                if (Double.isNaN(value)) {
                    return "NaN";
                }
                if (Double.isInfinite(value)) {
                    if (value >= 0.0) {
                        return "Infinity";
                    }
                    return "-Infinity";
                }
                return NativeNumber.num_to(value, args, 1, 3, 0, 1);
            }
            case 8: {
                if (args.length == 0 || args[0] == Undefined.instance) {
                    return ScriptRuntime.numberToString(value, 10);
                }
                if (Double.isNaN(value)) {
                    return "NaN";
                }
                if (Double.isInfinite(value)) {
                    if (value >= 0.0) {
                        return "Infinity";
                    }
                    return "-Infinity";
                }
                return NativeNumber.num_to(value, args, 0, 4, 1, 0);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    private static Object execConstructorCall(int id, Object[] args) {
        switch (id) {
            case -1: {
                if (args.length == 0 || Undefined.instance == args[0]) {
                    return Boolean.FALSE;
                }
                if (args[0] instanceof Number) {
                    return NativeNumber.isFinite(args[0]);
                }
                return Boolean.FALSE;
            }
            case -2: {
                if (args.length == 0 || Undefined.instance == args[0]) {
                    return Boolean.FALSE;
                }
                if (args[0] instanceof Number) {
                    return NativeNumber.isNaN((Number)args[0]);
                }
                return Boolean.FALSE;
            }
            case -3: {
                if (args.length == 0 || Undefined.instance == args[0]) {
                    return Boolean.FALSE;
                }
                if (args[0] instanceof Number) {
                    return NativeNumber.isInteger((Number)args[0]);
                }
                return Boolean.FALSE;
            }
            case -4: {
                if (args.length == 0 || Undefined.instance == args[0]) {
                    return Boolean.FALSE;
                }
                if (args[0] instanceof Number) {
                    return NativeNumber.isSafeInteger((Number)args[0]);
                }
                return Boolean.FALSE;
            }
            case -5: {
                return NativeGlobal.js_parseFloat(args);
            }
            case -6: {
                return NativeGlobal.js_parseInt(args);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public String toString() {
        return ScriptRuntime.numberToString(this.doubleValue, 10);
    }

    @Override
    public MemberType getTypeOf() {
        return MemberType.NUMBER;
    }

    private static String num_to(double val, Object[] args, int zeroArgMode, int oneArgMode, int precisionMin, int precisionOffset) {
        int precision;
        if (args.length == 0) {
            precision = 0;
            oneArgMode = zeroArgMode;
        } else {
            double p = ScriptRuntime.toInteger(args[0]);
            if (p < (double)precisionMin || p > 100.0) {
                String msg = ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(args[0]));
                throw ScriptRuntime.rangeError(msg);
            }
            precision = ScriptRuntime.toInt32(p);
        }
        StringBuilder sb = new StringBuilder();
        DToA.JS_dtostr(sb, oneArgMode, precision + precisionOffset, val);
        return sb.toString();
    }

    static Object isFinite(Object val) {
        double d = ScriptRuntime.toNumber(val);
        Double nd = d;
        return ScriptRuntime.wrapBoolean(!nd.isInfinite() && !nd.isNaN());
    }

    private static Boolean isNaN(Number val) {
        if (val instanceof Double) {
            return ((Double)val).isNaN();
        }
        double d = val.doubleValue();
        return Double.isNaN(d);
    }

    private static boolean isInteger(Number val) {
        if (val instanceof Double) {
            return NativeNumber.isDoubleInteger((Double)val);
        }
        return NativeNumber.isDoubleInteger(val.doubleValue());
    }

    private static boolean isDoubleInteger(Double d) {
        return !d.isInfinite() && !d.isNaN() && Math.floor(d) == d;
    }

    private static boolean isDoubleInteger(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d) && Math.floor(d) == d;
    }

    private static boolean isSafeInteger(Number val) {
        if (val instanceof Double) {
            return NativeNumber.isDoubleSafeInteger((Double)val);
        }
        return NativeNumber.isDoubleSafeInteger(val.doubleValue());
    }

    private static boolean isDoubleSafeInteger(Double d) {
        return NativeNumber.isDoubleInteger(d) && d <= 9.007199254740991E15 && d >= -9.007199254740991E15;
    }

    private static boolean isDoubleSafeInteger(double d) {
        return NativeNumber.isDoubleInteger(d) && d <= 9.007199254740991E15 && d >= -9.007199254740991E15;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "toString" -> 2;
            case "toLocaleString" -> 3;
            case "toSource" -> 4;
            case "valueOf" -> 5;
            case "toFixed" -> 6;
            case "toExponential" -> 7;
            case "toPrecision" -> 8;
            default -> super.findPrototypeId(s);
        };
    }
}

