/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.classdata;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.classdata.ClassData;
import java.util.HashMap;
import java.util.Map;

public class ClassDataCache {
    public final Context context;
    private final Object lock;
    private final Map<Class<?>, ClassData> cache;
    final ClassData objectClassData;
    private final ClassData arrayClassData;
    private final ClassData classClassData;

    public ClassDataCache(Context cx) {
        this.context = cx;
        this.lock = new Object();
        this.cache = new HashMap();
        this.objectClassData = new ClassData(this, Object.class);
        this.arrayClassData = new ClassData(this, Object[].class);
        this.classClassData = new ClassData(this, Class.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassData of(Class<?> c) {
        if (c == null || c == Object.class) {
            return this.objectClassData;
        }
        if (c == Class.class) {
            return this.classClassData;
        }
        if (c.isArray()) {
            return this.arrayClassData;
        }
        Object object = this.lock;
        synchronized (object) {
            ClassData d = this.cache.get(c);
            if (d == null) {
                d = new ClassData(this, c);
                this.cache.put(c, d);
            }
            return d;
        }
    }
}

