/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.classdata;

import dev.latvian.mods.rhino.Context;

public class MethodSignature {
    public static final MethodSignature EMPTY = new MethodSignature(new Class[0]);
    public static final MethodSignature OBJECT = new MethodSignature(Object.class);
    public static final MethodSignature OBJECT_ARRAY = new MethodSignature(Object[].class);
    public static final MethodSignature STRING = new MethodSignature(String.class);
    public static final MethodSignature BYTE = new MethodSignature(Byte.TYPE);
    public static final MethodSignature SHORT = new MethodSignature(Short.TYPE);
    public static final MethodSignature INT = new MethodSignature(Integer.TYPE);
    public static final MethodSignature LONG = new MethodSignature(Long.TYPE);
    public static final MethodSignature FLOAT = new MethodSignature(Float.TYPE);
    public static final MethodSignature DOUBLE = new MethodSignature(Double.TYPE);
    public static final MethodSignature BOOLEAN = new MethodSignature(Boolean.TYPE);
    public static final MethodSignature CHAR = new MethodSignature(Character.TYPE);
    public final Class<?>[] types;
    private String string = null;
    private int hashCode = 0;

    public static MethodSignature of(Class<?> ... types) {
        if (types.length == 0) {
            return EMPTY;
        }
        if (types.length == 1) {
            if (types[0] == Object.class) {
                return OBJECT;
            }
            if (types[0] == Object[].class) {
                return OBJECT_ARRAY;
            }
            if (types[0] == String.class) {
                return STRING;
            }
            if (types[0] == Byte.TYPE) {
                return BYTE;
            }
            if (types[0] == Short.TYPE) {
                return SHORT;
            }
            if (types[0] == Integer.TYPE) {
                return INT;
            }
            if (types[0] == Long.TYPE) {
                return LONG;
            }
            if (types[0] == Float.TYPE) {
                return FLOAT;
            }
            if (types[0] == Double.TYPE) {
                return DOUBLE;
            }
            if (types[0] == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (types[0] == Character.TYPE) {
                return CHAR;
            }
        }
        return new MethodSignature(types);
    }

    private MethodSignature(Class<?> ... types) {
        this.types = types;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodSignature) {
            MethodSignature o = (MethodSignature)obj;
            if (this.types.length != o.types.length) {
                return false;
            }
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i] == o.types[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (Class<?> type : this.types) {
                sb.append(type.descriptorString());
            }
            sb.append(')');
            this.string = sb.toString();
        }
        return this.string;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int h = 1;
            for (Class<?> type : this.types) {
                h = 31 * h + type.hashCode();
            }
            this.hashCode = h == 0 ? 1 : h;
        }
        return this.hashCode;
    }

    public boolean matches(MethodSignature actualArguments, Context cx) {
        if (this == actualArguments) {
            return true;
        }
        return this.equals(actualArguments);
    }
}

