/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Function;

public interface Remapper {
    public String remapClass(Class<?> var1, String var2);

    public String unmapClass(String var1);

    public String remapField(Class<?> var1, Field var2, String var3);

    public String remapMethod(Class<?> var1, Method var2, String var3);

    default public String getMappedClass(Class<?> from) {
        String n = from.getName();
        String s = this.remapClass(from, n);
        return s.isEmpty() ? n : s;
    }

    default public String getUnmappedClass(String from) {
        String s = this.unmapClass(from);
        return s.isEmpty() ? from : s;
    }

    default public String getMappedField(Class<?> from, Field field) {
        return this.getMappedField(from, field, field.getName());
    }

    default public String getMappedField(Class<?> from, Field field, String fieldName) {
        if (from == null || from == Object.class) {
            return field.getName();
        }
        String s = this.remapField(from, field, fieldName);
        if (!s.isEmpty()) {
            return s;
        }
        String ss = this.getMappedField(from.getSuperclass(), field, fieldName);
        if (!ss.isEmpty()) {
            return ss;
        }
        for (Class<?> c : from.getInterfaces()) {
            String si = this.getMappedField(c, field, fieldName);
            if (si.isEmpty()) continue;
            return si;
        }
        return field.getName();
    }

    default public String getMappedMethod(Class<?> from, Method method) {
        StringBuilder sb = new StringBuilder(method.getName());
        sb.append('(');
        if (method.getParameterCount() > 0) {
            for (Class<?> param : method.getParameterTypes()) {
                sb.append(Remapper.getTypeName(param.getTypeName()));
            }
        }
        sb.append(')');
        return this.getMappedMethod(from, method, sb.toString());
    }

    default public String getMappedMethod(Class<?> from, Method method, String methodString) {
        if (from == null || from == Object.class) {
            return method.getName();
        }
        String s = this.remapMethod(from, method, methodString);
        if (!s.isEmpty()) {
            return s;
        }
        String ss = this.getMappedMethod(from.getSuperclass(), method, methodString);
        if (!ss.isEmpty()) {
            return ss;
        }
        for (Class<?> c : from.getInterfaces()) {
            String si = this.getMappedMethod(c, method, methodString);
            if (si.isEmpty()) continue;
            return si;
        }
        return method.getName();
    }

    public static String getTypeName(String type, Function<String, String> remap) {
        int array = 0;
        while (type.endsWith("[]")) {
            ++array;
            type = type.substring(0, type.length() - 2);
        }
        String t = switch (type) {
            case "boolean" -> "Z";
            case "byte" -> "B";
            case "short" -> "S";
            case "int" -> "I";
            case "long" -> "J";
            case "float" -> "F";
            case "double" -> "D";
            case "char" -> "C";
            case "void" -> "V";
            default -> "L" + remap.apply(type.replace('/', '.')).replace('.', '/') + ";";
        };
        return array == 0 ? t : "[".repeat(array) + t;
    }

    public static String getTypeName(String type) {
        return Remapper.getTypeName(type, Function.identity());
    }
}

