/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.unit.function;

import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;
import dev.latvian.mods.unit.function.ClampFuncUnit;
import dev.latvian.mods.unit.function.FuncUnit;
import dev.latvian.mods.unit.function.FunctionFactory;

public class HsvFuncUnit
extends FuncUnit {
    public static final FunctionFactory FACTORY = FunctionFactory.of("hsv", 3, 4, HsvFuncUnit::new);
    public final Unit h;
    public final Unit s;
    public final Unit v;
    public final Unit a;

    public HsvFuncUnit(Unit[] args) {
        super(FACTORY);
        this.h = args[0];
        this.s = args[1];
        this.v = args[2];
        this.a = args.length == 4 ? args[3] : FixedNumberUnit.ONE;
    }

    @Override
    protected Unit[] getArguments() {
        if (this.a == FixedNumberUnit.ONE) {
            return new Unit[]{this.h, this.s, this.v};
        }
        return new Unit[]{this.h, this.s, this.v, this.a};
    }

    @Override
    public double get(UnitVariables variables) {
        return this.getInt(variables);
    }

    @Override
    public int getInt(UnitVariables variables) {
        double dg;
        double dr;
        double h = this.h.get(variables);
        double s = this.s.get(variables);
        double v = this.v.get(variables);
        int i = (int)(h * 6.0) % 6;
        double j = h * 6.0 - (double)i;
        double k = v * (1.0 - s);
        double l = v * (1.0 - j * s);
        double m = v * (1.0 - (1.0 - j) * s);
        double db = switch (i) {
            case 0 -> {
                dr = v;
                dg = m;
                yield k;
            }
            case 1 -> {
                dr = l;
                dg = v;
                yield k;
            }
            case 2 -> {
                dr = k;
                dg = v;
                yield m;
            }
            case 3 -> {
                dr = k;
                dg = l;
                yield v;
            }
            case 4 -> {
                dr = m;
                dg = k;
                yield v;
            }
            case 5 -> {
                dr = v;
                dg = k;
                yield l;
            }
            default -> {
                dr = 0.0;
                dg = 0.0;
                yield 0.0;
            }
        };
        int cr = (int)ClampFuncUnit.clamp(dr * 255.0, 0.0, 255.0);
        int cg = (int)ClampFuncUnit.clamp(dg * 255.0, 0.0, 255.0);
        int cb = (int)ClampFuncUnit.clamp(db * 255.0, 0.0, 255.0);
        int ca = (int)ClampFuncUnit.clamp(this.a.get(variables) * 255.0, 0.0, 255.0);
        return ca << 24 | cr << 16 | cg << 8 | cb;
    }

    @Override
    public boolean getBoolean(UnitVariables variables) {
        return this.a.getBoolean(variables);
    }

    @Override
    public Unit withAlpha(Unit a) {
        if (a == this.a) {
            return this;
        }
        return new HsvFuncUnit(new Unit[]{this.h, this.s, this.v, a});
    }
}

