/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.config.value;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.config.value.OptionValue;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class InputOptionValue<T>
extends OptionValue<T> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("^[0-9]*$");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)") || s.endsWith(".") || s.isEmpty();
    private final EditBox textField;

    public InputOptionValue(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        super(optionName, setter);
        this.value = value;
        this.textField = new WatchedTextfield(this, this.client.f_91062_, 0, 0, 98, 18);
        this.textField.m_94144_(String.valueOf(value));
        this.textField.m_94153_(validator);
    }

    @Override
    protected void drawValue(PoseStack matrixStack, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.f_93620_ = x;
        this.textField.f_93621_ = y + entryHeight / 6;
        this.textField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public AbstractWidget getListener() {
        return this.textField;
    }

    private void setValue(String text) {
        if (this.value instanceof String) {
            this.value = text;
        }
        try {
            if (this.value instanceof Integer) {
                this.value = Integer.valueOf(text);
            } else if (this.value instanceof Short) {
                this.value = Short.valueOf(text);
            } else if (this.value instanceof Byte) {
                this.value = Byte.valueOf(text);
            } else if (this.value instanceof Long) {
                this.value = Long.valueOf(text);
            } else if (this.value instanceof Double) {
                this.value = Double.valueOf(text);
            } else if (this.value instanceof Float) {
                this.value = Float.valueOf(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.save();
    }

    private static class WatchedTextfield
    extends EditBox {
        private final InputOptionValue<?> watcher;

        public WatchedTextfield(InputOptionValue<?> watcher, Font fontRenderer, int x, int y, int width, int height) {
            super(fontRenderer, x, y, width, height, (Component)new TextComponent(""));
            this.watcher = watcher;
        }

        public void m_94164_(String string) {
            super.m_94164_(string);
            this.watcher.setValue(this.m_94155_());
        }

        public void m_94144_(String value) {
            super.m_94144_(value);
            this.watcher.setValue(this.m_94155_());
        }

        public void m_94176_(int count) {
            super.m_94176_(count);
            this.watcher.setValue(this.m_94155_());
        }

        public void m_94196_(int pos) {
            super.m_94196_(pos);
            this.watcher.setValue(this.m_94155_());
        }
    }
}

