/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.impl;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.AccessorImpl;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.WailaClientRegistration;
import mcp.mobius.waila.impl.WailaCommonRegistration;
import mcp.mobius.waila.impl.config.PluginConfig;
import mcp.mobius.waila.impl.ui.FluidStackElement;
import mcp.mobius.waila.impl.ui.ItemStackElement;
import mcp.mobius.waila.network.RequestTilePacket;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;

public class BlockAccessorImpl
extends AccessorImpl<BlockHitResult>
implements BlockAccessor {
    private final BlockState blockState;
    private final BlockEntity blockEntity;
    private final ItemStack fakeBlock;

    public BlockAccessorImpl(BlockState blockState, BlockEntity blockEntity, Level level, Player player, CompoundTag serverData, BlockHitResult hit, boolean serverConnected, ItemStack fakeBlock) {
        super(level, player, serverData, hit, serverConnected);
        this.blockState = blockState;
        this.blockEntity = blockEntity;
        this.fakeBlock = fakeBlock;
    }

    @Override
    public Block getBlock() {
        return this.getBlockState().m_60734_();
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public BlockPos getPosition() {
        return ((BlockHitResult)this.getHitResult()).m_82425_();
    }

    @Override
    public Direction getSide() {
        return ((BlockHitResult)this.getHitResult()).m_82434_();
    }

    @Override
    public ItemStack getPickedResult() {
        return this.getBlockState().getCloneItemStack(this.getHitResult(), (BlockGetter)this.getLevel(), this.getPosition(), this.getPlayer());
    }

    @Override
    public IElement _getIcon() {
        if (this.blockState.m_60795_()) {
            return null;
        }
        IElement icon = null;
        if (this.isFakeBlock()) {
            icon = ItemStackElement.of(this.getFakeBlock());
        } else {
            ItemStack pick = this.getPickedResult();
            if (!pick.m_41619_()) {
                icon = ItemStackElement.of(pick);
            }
        }
        if (RayTracing.isEmptyElement(icon) && this.getBlock().m_5456_() != Items.f_41852_) {
            icon = ItemStackElement.of(new ItemStack((ItemLike)this.getBlock()));
        }
        if (RayTracing.isEmptyElement(icon) && this.getBlock() instanceof LiquidBlock) {
            LiquidBlock block = (LiquidBlock)this.getBlock();
            FlowingFluid fluid = block.getFluid();
            FluidStack fluidStack = new FluidStack((Fluid)fluid, 1);
            icon = new FluidStackElement(fluidStack);
        }
        for (IComponentProvider provider : WailaClientRegistration.INSTANCE.getBlockIconProviders(this.getBlock())) {
            try {
                IElement element = provider.getIcon(this, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider.getClass().toString(), null);
            }
        }
        return icon;
    }

    @Override
    public void _gatherComponents(ITooltip tooltip) {
        List<IComponentProvider> providers = WailaClientRegistration.INSTANCE.getBlockProviders(this.getBlock(), this.getTooltipPosition());
        for (IComponentProvider provider : providers) {
            try {
                provider.appendTooltip(tooltip, this, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    @Override
    public boolean shouldDisplay() {
        return Waila.CONFIG.get().getGeneral().getDisplayBlocks();
    }

    @Override
    public void _requestData(boolean showDetails) {
        Waila.NETWORK.sendToServer((Object)new RequestTilePacket(this.blockEntity, showDetails));
    }

    @Override
    public boolean shouldRequestData() {
        if (this.blockEntity == null) {
            return false;
        }
        return !WailaCommonRegistration.INSTANCE.getBlockNBTProviders(this.blockEntity).isEmpty();
    }

    @Override
    public boolean _verifyData(CompoundTag serverData) {
        int x = serverData.m_128451_("x");
        int y = serverData.m_128451_("y");
        int z = serverData.m_128451_("z");
        BlockPos hitPos = this.getPosition();
        return x == hitPos.m_123341_() && y == hitPos.m_123342_() && z == hitPos.m_123343_();
    }

    @Override
    public Object _getTrackObject() {
        return this.getBlockEntity();
    }

    @Override
    public boolean isFakeBlock() {
        return !this.fakeBlock.m_41619_();
    }

    @Override
    public ItemStack getFakeBlock() {
        return this.fakeBlock;
    }
}

