/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.probejs.ProbeConfig;
import com.probejs.compiler.SchemaCompiler;
import com.probejs.compiler.SnippetCompiler;
import com.probejs.compiler.TypingCompiler;
import com.probejs.document.Manager;
import com.probejs.document.comment.CommentHandler;
import com.probejs.document.parser.processor.DocumentProviderHandler;
import com.probejs.formatter.ClassResolver;
import com.probejs.formatter.NameResolver;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ProbeCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"probejs").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires(source -> source.m_81377_().m_129792_() && source.m_6761_(2))).executes(context -> {
            Instant start = Instant.now();
            try {
                SnippetCompiler.compile();
                SchemaCompiler.compile();
                DocumentProviderHandler.init();
                CommentHandler.init();
                Manager.init();
                ClassResolver.init();
                NameResolver.init();
                TypingCompiler.compile();
                if (ProbeConfig.INSTANCE.exportClassNames) {
                    SnippetCompiler.compileClassNames();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Uncaught exception happened in wrapper, please report to the Github issue with complete latest.log."), false);
            }
            Instant end = Instant.now();
            Duration duration = Duration.between(start, end);
            long sub = TimeUnit.MILLISECONDS.convert(duration.getNano(), TimeUnit.NANOSECONDS);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("ProbeJS typing generation finished in %s.%ss.".formatted(duration.getSeconds(), sub)), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_cache").requires(source -> source.m_81377_().m_129792_())).executes(context -> {
            Path path = KubeJSPaths.EXPORTED.resolve("cachedEvents.json");
            if (Files.exists(path, new LinkOption[0])) {
                if (path.toFile().delete()) {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Cache files removed."), false);
                } else {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Failed to remove cache files."), false);
                }
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("No cached files to be cleared."), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"configure").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle_bean").requires(source -> source.m_81377_().m_129792_())).executes(context -> {
            ProbeConfig.INSTANCE.dumpMethod = !ProbeConfig.INSTANCE.dumpMethod;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Keep method while beaning set to: %s".formatted(ProbeConfig.INSTANCE.dumpMethod)), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle_aggressive").requires(source -> source.m_81377_().m_129792_())).executes(context -> {
            ProbeConfig.INSTANCE.noAggressiveProbing = !ProbeConfig.INSTANCE.noAggressiveProbing;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Aggressive mode is now: %s".formatted(ProbeConfig.INSTANCE.noAggressiveProbing ? "disabled" : "enabled")), false);
            ProbeConfig.INSTANCE.save();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Changes will be applied next time you start the game."), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle_snippet_order").requires(source -> source.m_81377_().m_129792_())).executes(context -> {
            ProbeConfig.INSTANCE.vanillaOrder = !ProbeConfig.INSTANCE.vanillaOrder;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("In snippets, which will appear first: %s".formatted(ProbeConfig.INSTANCE.vanillaOrder ? "mod_id" : "member_type")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle_classname_snippets").requires(source -> source.m_81377_().m_129792_())).executes(context -> {
            ProbeConfig.INSTANCE.exportClassNames = !ProbeConfig.INSTANCE.exportClassNames;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Export class name as snippets set to: %s".formatted(ProbeConfig.INSTANCE.exportClassNames)), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))));
    }
}

