/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.google.gson.GsonBuilder;
import com.probejs.ProbeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;

public class ProbeConfig {
    public static ProbeConfig INSTANCE = new ProbeConfig();
    private static final Path CONFIG = KubeJSPaths.CONFIG.resolve("probejs.json");
    public boolean dumpMethod = true;
    public boolean noAggressiveProbing = false;
    public boolean vanillaOrder = true;
    public boolean exportClassNames = false;

    private static <E> E fetchPropertyOrDefault(Object key, Map<?, ?> value, E defaultValue) {
        Object v = value.get(key);
        return (E)(v == null ? defaultValue : v);
    }

    private ProbeConfig() {
        Path cfg = KubeJSPaths.CONFIG.resolve("probejs.json");
        if (Files.exists(cfg, new LinkOption[0])) {
            try {
                Map obj = (Map)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cfg), Map.class);
                this.dumpMethod = ProbeConfig.fetchPropertyOrDefault("dumpMethod", obj, true);
                this.noAggressiveProbing = ProbeConfig.fetchPropertyOrDefault("disabled", obj, false);
                this.vanillaOrder = ProbeConfig.fetchPropertyOrDefault("vanillaOrder", obj, true);
                this.exportClassNames = ProbeConfig.fetchPropertyOrDefault("exportClassNames", obj, false);
            }
            catch (IOException e) {
                ProbeJS.LOGGER.warn("Cannot read config properties, falling back to defaults.");
            }
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            ProbeJS.LOGGER.warn("Cannot write config, settings are not saved.");
        }
    }
}

