/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.formatter.formatter.FormatterNamespace;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.formatter.formatter.clazz.FormatterClass;
import com.probejs.info.type.TypeInfoClass;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RegistryCompiler {
    public static Set<Class<?>> getRegistryClasses() {
        HashSet result = new HashSet();
        result.add(RegistryObjectBuilderTypes.class);
        result.add(RegistryObjectBuilderTypes.RegistryEventJS.class);
        RegistryObjectBuilderTypes.MAP.values().forEach(v -> v.types.values().forEach(v1 -> result.add(v1.builderClass())));
        return result;
    }

    public static void compileEventRegistries(BufferedWriter writer) throws IOException {
        for (RegistryObjectBuilderTypes types : RegistryObjectBuilderTypes.MAP.values()) {
            String fullName = types.registryKey.m_135782_().m_135827_() + "." + types.registryKey.m_135782_().m_135815_().replace('/', '.') + ".registry";
            String registryName = FormatterRegistry.getFormattedRegistryName(types);
            writer.write("declare function onEvent(name: %s, handler: (event: Registry.%s) => void);\n".formatted(ProbeJS.GSON.toJson((Object)fullName), registryName));
            if (!types.registryKey.m_135782_().m_135827_().equals("minecraft")) continue;
            String shortName = types.registryKey.m_135782_().m_135815_().replace('/', '.') + ".registry";
            writer.write("declare function onEvent(name: %s, handler: (event: Registry.%s) => void);\n".formatted(ProbeJS.GSON.toJson((Object)shortName), registryName));
        }
    }

    public static void compileRegistries() throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("registries.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        FormatterNamespace namespace = new FormatterNamespace("Registry", RegistryObjectBuilderTypes.MAP.values().stream().map(FormatterRegistry::new).collect(Collectors.toList()));
        writer.write(String.join((CharSequence)"\n", namespace.format(0, 4)));
        writer.flush();
    }

    private static class FormatterRegistry
    implements IFormatter {
        RegistryObjectBuilderTypes<?> types;
        String name;

        private static String getFormattedRegistryName(RegistryObjectBuilderTypes<?> types) {
            return Arrays.stream(types.registryKey.m_135782_().m_135815_().split("/")).map(str -> str.substring(0, 1).toUpperCase() + str.substring(1)).collect(Collectors.joining(""));
        }

        private FormatterRegistry(RegistryObjectBuilderTypes<?> types) {
            this.types = types;
            this.name = FormatterRegistry.getFormattedRegistryName(types);
        }

        @Override
        public List<String> format(Integer indent, Integer stepIndent) {
            ArrayList<String> formatted = new ArrayList<String>();
            int stepped = indent + stepIndent;
            formatted.add(" ".repeat(indent) + "class %s extends %s {".formatted(this.name, FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)((Object)RegistryObjectBuilderTypes.RegistryEventJS.class)))));
            for (RegistryObjectBuilderTypes.BuilderType builder : this.types.types.values()) {
                formatted.add(" ".repeat(stepped) + "create(id: string, type: %s): %s;".formatted(ProbeJS.GSON.toJson((Object)builder.type()), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)builder.builderClass()))));
            }
            if (this.types.getDefaultType() != null) {
                formatted.add(" ".repeat(stepped) + "create(id: string): %s;".formatted(FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)this.types.getDefaultType().builderClass()))));
            }
            formatted.add(" ".repeat(indent) + "}");
            return formatted;
        }
    }
}

