/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeConfig;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.special.FormatterTag;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SnippetCompiler {
    public static void compile() throws IOException {
        Path codeFile = ProbePaths.SNIPPET.resolve("probe.code-snippets");
        KubeDump kubeDump = KubeDump.fetch();
        BufferedWriter writer = Files.newBufferedWriter(codeFile, new OpenOption[0]);
        writer.write(ProbeJS.GSON.toJson((JsonElement)kubeDump.toSnippet()));
        writer.flush();
    }

    public static void compileClassNames() throws IOException {
        JsonObject resultJson = new JsonObject();
        for (Map.Entry<String, List<NameResolver.ResolvedName>> entry : NameResolver.resolvedNames.entrySet()) {
            String className = entry.getKey();
            List<NameResolver.ResolvedName> resolvedNames = entry.getValue();
            for (NameResolver.ResolvedName resolvedName : resolvedNames) {
                JsonObject classJson = new JsonObject();
                JsonArray prefix = new JsonArray();
                prefix.add("!%s".formatted(resolvedName.getFullName().replace("$", "\\$")));
                classJson.add("prefix", (JsonElement)prefix);
                classJson.addProperty("body", className);
                resultJson.add(resolvedName.getFullName(), (JsonElement)classJson);
            }
        }
        Path codeFile = ProbePaths.SNIPPET.resolve("classNames.code-snippets");
        BufferedWriter writer = Files.newBufferedWriter(codeFile, new OpenOption[0]);
        ProbeJS.GSON.toJson((JsonElement)resultJson, (Appendable)writer);
        writer.flush();
    }

    public static class KubeDump {
        public Map<String, Map<String, List<String>>> tags;
        public Map<String, List<String>> registries;

        public KubeDump(Map<String, Map<String, List<String>>> tags, Map<String, List<String>> registries) {
            this.tags = tags;
            this.registries = registries;
        }

        private static void putTag(Map<String, Map<String, List<String>>> tags, String type, Registry<?> registry) {
            tags.put(type, FormatterTag.getTagsFromRegistry(registry).stream().collect(Collectors.toMap(s -> s, s -> new ArrayList())));
        }

        private static <T> void putRegistry(Map<String, List<String>> registries, String type, ResourceKey<Registry<T>> registry) {
            registries.put(type, KubeJSRegistries.genericRegistry(registry).getIds().stream().map(ResourceLocation::toString).toList());
        }

        public static KubeDump fetch() {
            HashMap<String, Map<String, List<String>>> tags = new HashMap<String, Map<String, List<String>>>();
            HashMap<String, List<String>> registries = new HashMap<String, List<String>>();
            KubeDump.putTag(tags, "items", Registry.f_122827_);
            KubeDump.putTag(tags, "blocks", Registry.f_122824_);
            KubeDump.putTag(tags, "fluids", Registry.f_122822_);
            KubeDump.putTag(tags, "entity_types", Registry.f_122826_);
            KubeDump.putRegistry(registries, "items", Registry.f_122904_);
            KubeDump.putRegistry(registries, "blocks", Registry.f_122901_);
            KubeDump.putRegistry(registries, "fluids", Registry.f_122899_);
            KubeDump.putRegistry(registries, "entity_types", Registry.f_122903_);
            return new KubeDump(tags, registries);
        }

        public String toString() {
            return "KubeDump{tags=" + this.tags + ", registries=" + this.registries + "}";
        }

        public JsonObject toSnippet() {
            HashMap<String, List> byModMembers;
            List<String> members;
            String type;
            JsonObject resultJson = new JsonObject();
            for (Map.Entry<String, List<String>> entry : this.registries.entrySet()) {
                type = entry.getKey();
                members = entry.getValue();
                byModMembers = new HashMap<String, List>();
                members.stream().map(rl -> rl.split(":")).forEach(rl -> {
                    if (!byModMembers.containsKey(rl[0])) {
                        byModMembers.put(rl[0], new ArrayList());
                    }
                    ((List)byModMembers.get(rl[0])).add(rl[1]);
                });
                byModMembers.forEach((mod, modMembers) -> {
                    JsonObject modMembersJson = new JsonObject();
                    JsonArray prefixes = new JsonArray();
                    if (ProbeConfig.INSTANCE.vanillaOrder) {
                        prefixes.add("@%s.%s".formatted(mod, type));
                    } else {
                        prefixes.add("@%s.%s".formatted(type, mod));
                    }
                    modMembersJson.add("prefix", (JsonElement)prefixes);
                    modMembersJson.addProperty("body", "\"%s:${1|%s|}\"".formatted(mod, String.join((CharSequence)",", modMembers)));
                    resultJson.add("%s_%s".formatted(type, mod), (JsonElement)modMembersJson);
                });
            }
            for (Map.Entry<String, Object> entry : this.tags.entrySet()) {
                type = entry.getKey();
                members = ((Map)entry.getValue()).keySet().stream().toList();
                byModMembers = new HashMap();
                members.stream().map(rl -> rl.split(":")).forEach(rl -> {
                    if (!byModMembers.containsKey(rl[0])) {
                        byModMembers.put(rl[0], new ArrayList());
                    }
                    ((List)byModMembers.get(rl[0])).add(rl[1]);
                });
                byModMembers.forEach((mod, modMembers) -> {
                    JsonObject modMembersJson = new JsonObject();
                    JsonArray prefixes = new JsonArray();
                    if (ProbeConfig.INSTANCE.vanillaOrder) {
                        prefixes.add("@%s.tags.%s".formatted(mod, type));
                    } else {
                        prefixes.add("@%s.tags.%s".formatted(type, mod));
                    }
                    modMembersJson.add("prefix", (JsonElement)prefixes);
                    modMembersJson.addProperty("body", "\"%s:${1|%s|}\"".formatted(mod, String.join((CharSequence)",", modMembers)));
                    resultJson.add("%s_tag_%s".formatted(type, mod), (JsonElement)modMembersJson);
                });
            }
            return resultJson;
        }
    }
}

