/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.compiler.DummyBindingEvent;
import com.probejs.compiler.RegistryCompiler;
import com.probejs.compiler.SpecialCompiler;
import com.probejs.document.DocumentClass;
import com.probejs.document.DocumentComment;
import com.probejs.document.Manager;
import com.probejs.event.CapturedEvent;
import com.probejs.formatter.ClassResolver;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.SpecialTypes;
import com.probejs.formatter.formatter.FormatterNamespace;
import com.probejs.formatter.formatter.FormatterRawTS;
import com.probejs.formatter.formatter.clazz.FormatterClass;
import com.probejs.info.ClassInfo;
import com.probejs.info.Walker;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.plugin.CapturedClasses;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class TypingCompiler {
    public static Set<Class<?>> readCachedClasses(String fileName) throws IOException {
        HashSet cachedClasses = new HashSet();
        Path cachedClassesPath = KubeJSPaths.EXPORTED.resolve(fileName);
        if (Files.exists(cachedClassesPath, new LinkOption[0])) {
            try {
                List cachedList = (List)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedClassesPath), List.class);
                cachedList.forEach(c -> {
                    try {
                        Class<?> clazz = Class.forName((String)c);
                        cachedClasses.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        ProbeJS.LOGGER.warn("Class %s was in the cache, but disappeared in packages now.".formatted(c));
                    }
                });
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedClasses;
    }

    public static void writeCachedClasses(String fileName, Set<Class<?>> javaClasses) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(KubeJSPaths.EXPORTED.resolve(fileName), new OpenOption[0]);
        JsonArray outJson = new JsonArray();
        for (Class<?> clazz : javaClasses) {
            outJson.add(clazz.getName());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.flush();
    }

    public static Map<String, CapturedEvent> readCachedEvents(String fileName) throws IOException {
        HashMap<String, CapturedEvent> cachedEvents = new HashMap<String, CapturedEvent>();
        Path cachedEventPath = KubeJSPaths.EXPORTED.resolve(fileName);
        if (Files.exists(cachedEventPath, new LinkOption[0])) {
            try {
                JsonObject cachedMap = (JsonObject)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedEventPath), JsonObject.class);
                for (Map.Entry entry : cachedMap.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (!value.isJsonObject()) continue;
                    CapturedEvent.fromJson(value.getAsJsonObject()).ifPresent(event -> cachedEvents.put(key, (CapturedEvent)event));
                }
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedEvents;
    }

    public static Map<String, Class<?>> readCachedForgeEvents(String fileName) throws IOException {
        HashMap cachedEvents = new HashMap();
        Path cachedEventPath = KubeJSPaths.EXPORTED.resolve(fileName);
        if (Files.exists(cachedEventPath, new LinkOption[0])) {
            try {
                Map cachedMap = (Map)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedEventPath), Map.class);
                cachedMap.forEach((k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        try {
                            Class<?> clazz = Class.forName((String)v);
                            if (EventJS.class.isAssignableFrom(clazz)) {
                                cachedEvents.put((String)k, clazz);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            ProbeJS.LOGGER.warn("Class %s was in the cache, but disappeared in packages now.".formatted(v));
                        }
                    }
                });
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedEvents;
    }

    public static void writeCachedEvents(String fileName, Map<String, CapturedEvent> events) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(KubeJSPaths.EXPORTED.resolve(fileName), new OpenOption[0]);
        JsonObject outJson = new JsonObject();
        for (Map.Entry<String, CapturedEvent> entry : events.entrySet()) {
            String eventName = entry.getKey();
            CapturedEvent eventClass = entry.getValue();
            outJson.add(eventName, (JsonElement)eventClass.toJson());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.flush();
    }

    public static void writeCachedForgeEvents(String fileName, Map<String, Class<?>> events) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(KubeJSPaths.EXPORTED.resolve(fileName), new OpenOption[0]);
        JsonObject outJson = new JsonObject();
        for (Map.Entry<String, Class<?>> entry : events.entrySet()) {
            String eventName = entry.getKey();
            Class<?> eventClass = entry.getValue();
            outJson.addProperty(eventName, eventClass.getName());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.flush();
    }

    public static Set<Class<?>> fetchClasses(Map<ResourceLocation, RecipeTypeJS> typeMap, DummyBindingEvent bindingEvent, Set<Class<?>> cachedClasses) {
        HashSet touchableClasses = new HashSet(bindingEvent.getClassDumpMap().values());
        touchableClasses.addAll(cachedClasses);
        touchableClasses.addAll(typeMap.values().stream().map(recipeTypeJS -> ((RecipeJS)recipeTypeJS.factory.get()).getClass()).collect(Collectors.toList()));
        bindingEvent.getConstantDumpMap().values().stream().map(DummyBindingEvent::getConstantClassRecursive).forEach(touchableClasses::addAll);
        touchableClasses.addAll(CapturedClasses.capturedEvents.values().stream().map(CapturedEvent::getCaptured).collect(Collectors.toList()));
        touchableClasses.addAll(CapturedClasses.capturedRawEvents.values());
        touchableClasses.addAll(CapturedClasses.capturedJavaClasses);
        Walker walker = new Walker(touchableClasses);
        return walker.walk();
    }

    public static void compileGlobal(DummyBindingEvent bindingEvent, Set<Class<?>> globalClasses) throws IOException {
        bindingEvent.getClassDumpMap().forEach((s, c) -> NameResolver.putResolvedName(c, s));
        NameResolver.resolveNames(NameResolver.priorSortClasses(globalClasses));
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("globals.d.ts"), new OpenOption[0]);
        HashMap<String, List> namespaced = new HashMap<String, List>();
        for (Class<?> clazz : globalClasses) {
            ClassInfo info = ClassInfo.getOrCache(clazz);
            FormatterClass formatter = new FormatterClass(info);
            ((List)Manager.classDocuments.getOrDefault(clazz.getName(), new ArrayList())).forEach(formatter::addDocument);
            NameResolver.ResolvedName name = NameResolver.getResolvedName(info.getName());
            if (name.getNamespace().isEmpty()) {
                writer.write(String.join((CharSequence)"\n", formatter.format(0, 4)) + "\n");
                if (!clazz.isInterface()) continue;
                writer.write("declare const %s: %s;".formatted(name.getFullName(), name.getFullName()) + "\n");
                continue;
            }
            formatter.setInternal(true);
            namespaced.computeIfAbsent(name.getNamespace(), s -> new ArrayList()).add(formatter);
        }
        for (Map.Entry entry : namespaced.entrySet()) {
            String path = (String)entry.getKey();
            List formatters = (List)entry.getValue();
            FormatterNamespace namespace = new FormatterNamespace(path, formatters);
            writer.write(String.join((CharSequence)"\n", namespace.format(0, 4)) + "\n");
        }
        for (Map.Entry entry : Manager.classAdditions.entrySet()) {
            List document = (List)entry.getValue();
            DocumentClass start = (DocumentClass)document.get(0);
            document.subList(1, document.size()).forEach(start::merge);
        }
        writer.write(String.join((CharSequence)"\n", new FormatterNamespace("Document", Manager.classAdditions.values().stream().map(l -> (DocumentClass)l.get(0)).collect(Collectors.toList())).format(0, 4)) + "\n");
        writer.write(String.join((CharSequence)"\n", new FormatterNamespace("Type", Manager.typeDocuments).format(0, 4)) + "\n");
        writer.write(String.join((CharSequence)"\n", new FormatterNamespace("Special", SpecialCompiler.compileSpecial()).format(0, 4)) + "\n");
        writer.write(String.join((CharSequence)"\n", new FormatterRawTS(Manager.rawTSDoc).format(0, 4)) + "\n");
        writer.flush();
    }

    private static List<String> getAdditionalEventComments(CapturedEvent event) {
        ArrayList<String> comments = new ArrayList<String>();
        if (!event.getScriptTypes().isEmpty()) {
            comments.add("* ");
            comments.add("* The event fires on: %s.".formatted(event.getFormattedTypeString()));
        }
        comments.add("* ");
        comments.add("* The event is %scancellable.".formatted(event.isCancellable() ? "" : "**not** "));
        return comments;
    }

    public static void compileEvents(Map<String, CapturedEvent> cachedEvents, Map<String, Class<?>> cachedForgeEvents) throws IOException {
        Class event;
        String id;
        cachedEvents.putAll(CapturedClasses.capturedEvents);
        cachedForgeEvents.putAll(CapturedClasses.capturedRawEvents);
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("events.d.ts"), new OpenOption[0]);
        BufferedWriter writerDoc = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("events.documented.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        writer.write("/// <reference path=\"./registries.d.ts\" />\n");
        writerDoc.write("/// <reference path=\"./globals.d.ts\" />\n");
        writerDoc.write("/// <reference path=\"./registries.d.ts\" />\n");
        HashSet<CapturedEvent> wildcards = new HashSet<CapturedEvent>();
        for (Map.Entry<String, CapturedEvent> entry : cachedEvents.entrySet()) {
            List<Object> docStrings;
            CapturedEvent capturedEvent = entry.getValue();
            id = capturedEvent.getId();
            event = capturedEvent.getCaptured();
            String sub = capturedEvent.getSub();
            if (capturedEvent.hasSub()) {
                wildcards.add(capturedEvent);
            }
            Optional<DocumentComment> document = ((List)Manager.classDocuments.getOrDefault(event.getName(), new ArrayList())).stream().map(DocumentClass::getComment).filter(Objects::nonNull).findFirst();
            String name = id + (String)(sub == null ? "" : "." + sub);
            if (document.isPresent()) {
                docStrings = document.get().format(0, 4);
                docStrings.addAll(docStrings.size() - 1, TypingCompiler.getAdditionalEventComments(capturedEvent));
                for (String string : docStrings) {
                    writerDoc.write(string + "\n");
                }
                writerDoc.write("declare function onEvent(name: %s, handler: (event: %s) => void);\n".formatted(ProbeJS.GSON.toJson((Object)name), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)event))));
                continue;
            }
            docStrings = new ArrayList<String>();
            docStrings.add("/**");
            docStrings.addAll(TypingCompiler.getAdditionalEventComments(capturedEvent));
            docStrings.add("*/");
            for (String string : docStrings) {
                writer.write(string + "\n");
            }
            writer.write("declare function onEvent(name: %s, handler: (event: %s) => void);\n".formatted(ProbeJS.GSON.toJson((Object)name), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)event))));
        }
        HashSet<String> writtenWildcards = new HashSet<String>();
        for (CapturedEvent capturedEvent : wildcards) {
            id = ProbeJS.GSON.toJson((Object)capturedEvent.getId());
            if (writtenWildcards.contains(id)) continue;
            writtenWildcards.add(id);
            Optional<DocumentComment> document = ((List)Manager.classDocuments.getOrDefault(capturedEvent.getCaptured().getName(), new ArrayList())).stream().map(DocumentClass::getComment).filter(Objects::nonNull).findFirst();
            if (document.isPresent()) {
                for (String s : document.get().format(0, 4)) {
                    writerDoc.write(s + "\n");
                }
                writerDoc.write("declare function onEvent(name: `%s.${string}`, handler: (event: %s) => void);\n".formatted(id.substring(1, id.length() - 1), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)capturedEvent.getCaptured()))));
                continue;
            }
            writer.write("declare function onEvent(name: `%s.${string}`, handler: (event: %s) => void);\n".formatted(id.substring(1, id.length() - 1), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)capturedEvent.getCaptured()))));
        }
        for (Map.Entry entry : cachedForgeEvents.entrySet()) {
            String name = (String)entry.getKey();
            event = (Class)entry.getValue();
            writer.write("declare function onForgeEvent(name: %s, handler: (event: %s) => void);\n".formatted(ProbeJS.GSON.toJson((Object)name), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)event))));
        }
        RegistryCompiler.compileEventRegistries(writer);
        writer.flush();
        writerDoc.flush();
    }

    public static void compileConstants(DummyBindingEvent bindingEvent) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("constants.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (Map.Entry<String, Object> entry : bindingEvent.getConstantDumpMap().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            String resolved = NameResolver.formatValue(value);
            writer.write("declare const %s: %s;\n".formatted(name, resolved == null ? FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)value.getClass())) : resolved));
        }
        writer.flush();
    }

    private static String formatJavaType(ClassInfo c) {
        if (c.isInterface()) {
            return "declare function java(name: \"%s\"): TSDoc.JavaInterface<%s>;\n".formatted(c.getName(), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)c.getClazzRaw())));
        }
        return "declare function java(name: \"%s\"): TSDoc.JavaClass<typeof %s>;\n".formatted(c.getName(), FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)c.getClazzRaw())));
    }

    public static void compileJava(Set<Class<?>> globalClasses) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("java.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (Class<?> c : globalClasses) {
            ClassInfo info = ClassInfo.getOrCache(c);
            if (!ServerScriptManager.instance.scriptManager.isClassAllowed(c.getName())) continue;
            writer.write(TypingCompiler.formatJavaType(info));
        }
        writer.write("/**\n* This name is not present in current ProbeJS's dump, if the class exists, dump after this java() is called to fetch typing.\n*/\n");
        writer.write("declare function java(name: string): never;\n");
        writer.flush();
    }

    public static void compileAdditionalTypeNames() throws IOException {
        Path path = ProbePaths.GENERATED.resolve("names.d.ts");
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("names.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (Map.Entry<String, List<NameResolver.ResolvedName>> entry : NameResolver.resolvedNames.entrySet()) {
            List<NameResolver.ResolvedName> exportedNames = entry.getValue();
            if (exportedNames.size() <= 1) continue;
            for (int i = 1; i < exportedNames.size(); ++i) {
                writer.write("const %s: typeof %s\n".formatted(exportedNames.get(i).getLastName(), exportedNames.get(0).getLastName()));
            }
        }
        writer.flush();
    }

    public static void compileJSConfig() throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(KubeJSPaths.DIRECTORY.resolve("jsconfig.json"), new OpenOption[0]);
        writer.write("{\n    \"compilerOptions\": {\n        \"lib\": [\"ES5\", \"ES2015\"],\n        \"typeRoots\": [\"./probe/generated\", \"./probe/user\"],\n        \"target\": \"ES2015\"\n    }\n}");
        writer.flush();
    }

    public static void compile() throws IOException {
        DummyBindingEvent bindingEvent = new DummyBindingEvent(ServerScriptManager.instance.scriptManager);
        HashMap<ResourceLocation, RecipeTypeJS> typeMap = new HashMap<ResourceLocation, RecipeTypeJS>();
        RegisterRecipeHandlersEvent recipeEvent = new RegisterRecipeHandlersEvent(typeMap);
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addRecipes(recipeEvent));
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addBindings((BindingsEvent)bindingEvent));
        Map<String, CapturedEvent> cachedEvents = TypingCompiler.readCachedEvents("cachedEvents.json");
        Map<String, Class<?>> cachedForgeEvents = TypingCompiler.readCachedForgeEvents("cachedForgeEvents.json");
        Set<Class<?>> cachedJavaClasses = TypingCompiler.readCachedClasses("cachedJava.json");
        HashSet cachedClasses = new HashSet();
        cachedEvents.values().forEach(v -> cachedClasses.add(v.getCaptured()));
        cachedClasses.addAll(cachedForgeEvents.values());
        cachedClasses.addAll(cachedJavaClasses);
        cachedClasses.addAll(RegistryCompiler.getRegistryClasses());
        Set<Class<?>> globalClasses = TypingCompiler.fetchClasses(typeMap, bindingEvent, cachedClasses);
        globalClasses.removeIf(c -> ClassResolver.skipped.contains(c));
        SpecialTypes.processFunctionalInterfaces(globalClasses);
        TypingCompiler.compileGlobal(bindingEvent, globalClasses);
        RegistryCompiler.compileRegistries();
        TypingCompiler.compileEvents(cachedEvents, cachedForgeEvents);
        TypingCompiler.compileConstants(bindingEvent);
        TypingCompiler.compileJava(globalClasses);
        TypingCompiler.compileAdditionalTypeNames();
        TypingCompiler.compileJSConfig();
        cachedJavaClasses.addAll(CapturedClasses.capturedJavaClasses);
        TypingCompiler.writeCachedEvents("cachedEvents.json", cachedEvents);
        TypingCompiler.writeCachedForgeEvents("cachedForgedEvents.json", cachedForgeEvents);
        TypingCompiler.writeCachedClasses("cachedJava.json", cachedJavaClasses);
    }
}

