/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.document;

import com.probejs.document.DocumentComment;
import com.probejs.document.DocumentField;
import com.probejs.document.DocumentMethod;
import com.probejs.document.DocumentProperty;
import com.probejs.document.IConcrete;
import com.probejs.document.IDecorative;
import com.probejs.document.IDocument;
import com.probejs.document.comment.CommentUtil;
import com.probejs.formatter.formatter.IFormatter;
import java.util.ArrayList;
import java.util.List;

public class DocumentClass
implements IConcrete,
IFormatter {
    private DocumentComment comment;
    private String name;
    private final List<DocumentField> fields = new ArrayList<DocumentField>();
    private final List<DocumentMethod> methods = new ArrayList<DocumentMethod>();

    public DocumentComment getComment() {
        return this.comment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void acceptProperty(IDocument document) {
        DocumentComment comment;
        if (document instanceof DocumentProperty && !CommentUtil.isLoaded(comment = ((DocumentProperty)document).getComment())) {
            return;
        }
        if (document instanceof DocumentField) {
            this.fields.add((DocumentField)document);
        }
        if (document instanceof DocumentMethod) {
            this.methods.add((DocumentMethod)document);
        }
    }

    public void merge(DocumentClass other) {
        if (this.comment == null) {
            this.comment = other.getComment();
        }
        this.fields.addAll(other.getFields());
        this.methods.addAll(other.getMethods());
    }

    public List<DocumentField> getFields() {
        return this.fields;
    }

    public List<DocumentMethod> getMethods() {
        return this.methods;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void acceptDeco(List<IDecorative> decorates) {
        for (IDecorative decorative : decorates) {
            if (!(decorative instanceof DocumentComment)) continue;
            this.comment = (DocumentComment)decorative;
        }
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        ArrayList<String> formatted = new ArrayList<String>();
        formatted.add(" ".repeat(indent) + "class %s {".formatted(this.name));
        this.getFields().forEach(f -> formatted.addAll(f.format(indent + stepIndent, stepIndent)));
        this.getMethods().forEach(m -> formatted.addAll(m.format(indent + stepIndent, stepIndent)));
        formatted.add(" ".repeat(indent) + "}");
        return formatted;
    }
}

