/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.document;

import com.probejs.document.DocumentProperty;
import com.probejs.document.parser.processor.IDocumentProvider;
import com.probejs.document.type.IType;
import com.probejs.document.type.Resolver;
import com.probejs.formatter.formatter.IFormatter;
import java.util.ArrayList;
import java.util.List;

public class DocumentField
extends DocumentProperty
implements IDocumentProvider<DocumentField>,
IFormatter {
    private final boolean isFinal;
    private final boolean isStatic;
    private final String name;
    private final IType type;

    public DocumentField(String line) {
        line = line.strip();
        boolean f = false;
        boolean s = false;
        boolean flag = true;
        while (flag) {
            if (line.startsWith("readonly")) {
                line = line.substring(8).strip();
                f = true;
                continue;
            }
            if (line.startsWith("static")) {
                line = line.substring(6).strip();
                s = true;
                continue;
            }
            flag = false;
        }
        String[] parts = line.split(":");
        this.name = parts[0].strip();
        this.type = Resolver.resolveType(parts[1].strip());
        this.isFinal = f;
        this.isStatic = s;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }

    public IType getType() {
        return this.type;
    }

    @Override
    public DocumentField provide() {
        return this;
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        ArrayList<String> formatted = new ArrayList<String>();
        if (this.comment != null) {
            formatted.addAll(this.comment.format(indent, stepIndent));
        }
        ArrayList<String> pre = new ArrayList<String>();
        if (this.isStatic) {
            pre.add("static");
        }
        if (this.isFinal) {
            pre.add("readonly");
        }
        pre.add("%s: %s;".formatted(this.name, this.type.getTypeName()));
        formatted.add(" ".repeat(indent) + String.join((CharSequence)" ", pre));
        return formatted;
    }
}

