/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.document;

import com.probejs.document.DocumentProperty;
import com.probejs.document.parser.processor.IDocumentProvider;
import com.probejs.document.type.IType;
import com.probejs.document.type.Resolver;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.info.MethodInfo;
import com.probejs.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DocumentMethod
extends DocumentProperty
implements IDocumentProvider<DocumentMethod>,
IFormatter {
    private final boolean isStatic;
    private final String name;
    private final IType returnType;
    private final List<DocumentParam> params;

    @Override
    public DocumentMethod provide() {
        return this;
    }

    public String getMethodBody() {
        StringBuilder sb = new StringBuilder();
        if (this.isStatic) {
            sb.append("static ");
        }
        sb.append(this.name);
        sb.append("(%s)");
        sb.append(": %s;".formatted(this.returnType.getTypeName()));
        return sb.toString();
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        ArrayList<String> formatted = new ArrayList<String>();
        if (this.comment != null) {
            formatted.addAll(this.comment.format(indent, stepIndent));
        }
        String methodBody = this.getMethodBody();
        formatted.add(" ".repeat(indent) + methodBody.formatted(this.getParams().stream().map(documentParam -> "%s: %s".formatted(documentParam.getName(), documentParam.getType().getTypeName())).collect(Collectors.joining(", "))));
        return formatted;
    }

    public DocumentMethod(String line) {
        line = line.strip();
        if (line.startsWith("static")) {
            line = line.substring(6).strip();
            this.isStatic = true;
        } else {
            this.isStatic = false;
        }
        int nameIndex = line.indexOf("(");
        int methodIndex = line.indexOf(")");
        this.name = line.substring(0, nameIndex).strip();
        String paramsString = line.substring(nameIndex + 1, methodIndex);
        String remainedString = line.substring(methodIndex + 1).replace(":", "").strip();
        this.params = StringUtil.splitLayer(paramsString, "<{(", ")}>", ",").stream().map(String::strip).filter(s -> !s.isEmpty()).map(s -> {
            String[] nameType = s.split(":", 2);
            return new DocumentParam(nameType[0].strip(), Resolver.resolveType(nameType[1]));
        }).collect(Collectors.toList());
        this.returnType = Resolver.resolveType(remainedString);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }

    public IType getReturnType() {
        return this.returnType;
    }

    public List<DocumentParam> getParams() {
        return this.params;
    }

    public boolean testMethod(MethodInfo methodInfo) {
        if (methodInfo.isStatic() != this.isStatic) {
            return false;
        }
        if (!Objects.equals(methodInfo.getName(), this.name)) {
            return false;
        }
        HashMap params = new HashMap();
        HashMap docParams = new HashMap();
        methodInfo.getParams().forEach(p -> params.put(p.getName(), p));
        this.params.forEach(p -> docParams.put(p.name, p));
        if (!params.keySet().equals(docParams.keySet())) {
            return false;
        }
        if (!Resolver.typeEquals(this.returnType, methodInfo.getReturnType())) {
            return false;
        }
        for (Map.Entry e : params.entrySet()) {
            DocumentParam doc = (DocumentParam)docParams.get(e.getKey());
            if (Resolver.typeEquals(doc.getType(), ((MethodInfo.ParamInfo)e.getValue()).getType())) continue;
            return false;
        }
        return true;
    }

    private static class DocumentParam {
        private final String name;
        private final IType type;

        private DocumentParam(String name, IType type) {
            this.name = name;
            this.type = type;
        }

        public IType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

