/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.document;

import com.probejs.document.DocumentComment;
import com.probejs.document.IConcrete;
import com.probejs.document.IDecorative;
import com.probejs.document.comment.CommentUtil;
import com.probejs.document.parser.processor.IDocumentProvider;
import com.probejs.document.type.IType;
import com.probejs.document.type.Resolver;
import com.probejs.formatter.formatter.IFormatter;
import java.util.ArrayList;
import java.util.List;

public class DocumentType
implements IDocumentProvider<DocumentType>,
IFormatter,
IConcrete {
    private DocumentComment comment;
    private final String name;
    private final IType type;

    public DocumentType(String line) {
        line = line.strip().substring(4).strip();
        if (line.endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        String[] nameType = line.split("=");
        this.name = nameType[0].strip();
        this.type = Resolver.resolveType(nameType[1].strip());
    }

    @Override
    public DocumentType provide() {
        return this;
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        if (!CommentUtil.isLoaded(this.comment) || CommentUtil.isHidden(this.comment)) {
            return new ArrayList<String>();
        }
        return List.of(" ".repeat(indent) + "type %s = %s;".formatted(this.name, this.type.getTypeName()));
    }

    @Override
    public void acceptDeco(List<IDecorative> decorates) {
        decorates.forEach(d -> {
            if (d instanceof DocumentComment) {
                this.comment = (DocumentComment)d;
            }
        });
    }

    public IType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public DocumentComment getComment() {
        return this.comment;
    }
}

