/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.document;

import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.document.DocumentClass;
import com.probejs.document.DocumentComment;
import com.probejs.document.DocumentType;
import com.probejs.document.IDocument;
import com.probejs.document.comment.CommentUtil;
import com.probejs.document.comment.special.CommentAssign;
import com.probejs.document.comment.special.CommentTarget;
import com.probejs.document.parser.processor.Document;
import com.probejs.document.type.IType;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Manager {
    public static Map<String, List<DocumentClass>> classDocuments = new HashMap<String, List<DocumentClass>>();
    public static Map<String, List<IType>> typesAssignable = new HashMap<String, List<IType>>();
    public static Map<String, List<DocumentClass>> classAdditions = new HashMap<String, List<DocumentClass>>();
    public static List<String> rawTSDoc = new ArrayList<String>();
    public static List<DocumentType> typeDocuments = new ArrayList<DocumentType>();

    public static void fromPath(Document document) throws IOException {
        File[] files = ProbePaths.DOCS.toFile().listFiles();
        ArrayList<File> filesSorted = files == null ? new ArrayList<File>() : new ArrayList<File>(Arrays.stream(files).toList());
        filesSorted.sort(Comparator.comparing(File::getName));
        for (File f : filesSorted) {
            if (!f.getName().endsWith(".d.ts")) {
                return;
            }
            if (f.isDirectory()) {
                return;
            }
            BufferedReader reader = Files.newBufferedReader(f.toPath());
            if (!f.getName().startsWith("!")) {
                reader.lines().forEach(document::step);
                continue;
            }
            reader.lines().forEach(rawTSDoc::add);
        }
    }

    public static void fromFiles(Document document) throws IOException {
        for (Mod mod : Platform.getMods()) {
            Optional docsList = mod.findResource(new String[]{"probejs.documents.txt"});
            if (!docsList.isPresent()) continue;
            ProbeJS.LOGGER.info("Found documents list from %s".formatted(mod.getName()));
            for (String subEntry : Files.lines((Path)docsList.get()).collect(Collectors.toList())) {
                if (subEntry.startsWith("!")) {
                    Optional docEntry;
                    int i = (subEntry = subEntry.substring(1)).indexOf(" ");
                    if (i != -1) {
                        if (!Platform.isModLoaded((String)subEntry.substring(0, i))) continue;
                        subEntry = subEntry.substring(i + 1);
                    }
                    if ((docEntry = mod.findResource(new String[]{subEntry})).isPresent()) {
                        ProbeJS.LOGGER.info("Loading raw document inside jar - %s".formatted(subEntry));
                        Files.lines((Path)docEntry.get()).forEach(rawTSDoc::add);
                        continue;
                    }
                    ProbeJS.LOGGER.warn("Document from file is not found - %s".formatted(subEntry));
                    continue;
                }
                Optional docEntry = mod.findResource(new String[]{subEntry});
                if (docEntry.isPresent()) {
                    ProbeJS.LOGGER.info("Loading document inside jar - %s".formatted(subEntry));
                    Files.lines((Path)docEntry.get()).forEach(document::step);
                    continue;
                }
                ProbeJS.LOGGER.warn("Document from file is not found - %s".formatted(subEntry));
            }
        }
    }

    public static void init() {
        classDocuments.clear();
        classAdditions.clear();
        typeDocuments.clear();
        typesAssignable.clear();
        rawTSDoc.clear();
        Document documentState = new Document();
        try {
            Manager.fromFiles(documentState);
            Manager.fromPath(documentState);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (IDocument doc : documentState.getDocument().getDocuments()) {
            DocumentClass classDoc;
            if (doc instanceof DocumentClass && CommentUtil.isLoaded((classDoc = (DocumentClass)doc).getComment())) {
                CommentTarget target;
                DocumentComment comment = classDoc.getComment();
                if (comment != null && (target = comment.getSpecialComment(CommentTarget.class)) != null) {
                    classDocuments.computeIfAbsent(target.getTargetName(), s -> new ArrayList()).add(classDoc);
                    List<CommentAssign> assignable = comment.getSpecialComments(CommentAssign.class);
                    typesAssignable.computeIfAbsent(target.getTargetName(), s -> new ArrayList()).addAll(assignable.stream().map(CommentAssign::getType).collect(Collectors.toList()));
                    continue;
                }
                classAdditions.computeIfAbsent(classDoc.getName(), s -> new ArrayList()).add(classDoc);
            }
            if (!(doc instanceof DocumentType) || !CommentUtil.isLoaded(((DocumentType)doc).getComment())) continue;
            typeDocuments.add((DocumentType)doc);
        }
    }
}

