/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.document.parser.processor;

import com.probejs.document.DocumentClass;
import com.probejs.document.IConcrete;
import com.probejs.document.IDecorative;
import com.probejs.document.IDocument;
import com.probejs.document.parser.handler.IStateHandler;
import com.probejs.document.parser.processor.IDocumentProvider;
import com.probejs.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class ProviderClass
implements IStateHandler<String>,
IDocumentProvider<DocumentClass> {
    public static List<Pair<Predicate<String>, BiFunction<String, ProviderClass, IStateHandler<String>>>> handlers = new ArrayList<Pair<Predicate<String>, BiFunction<String, ProviderClass, IStateHandler<String>>>>();
    private final List<IDocumentProvider<?>> elements = new ArrayList();
    private String name;

    public static void addMultiHandler(Predicate<String> condition, BiFunction<String, ProviderClass, IStateHandler<String>> handler) {
        handlers.add(new Pair<Predicate<String>, BiFunction<String, ProviderClass, IStateHandler<String>>>(condition, handler));
    }

    public static void addSingleHandler(Predicate<String> condition, BiConsumer<String, ProviderClass> handler) {
        handlers.add(new Pair<Predicate<String>, BiFunction<String, ProviderClass, IStateHandler>>(condition, (s, documentHandler) -> {
            handler.accept((String)s, (ProviderClass)documentHandler);
            return null;
        }));
    }

    public void addElement(IDocumentProvider<?> element) {
        this.elements.add(element);
    }

    @Override
    public void trial(String element, List<IStateHandler<String>> stack) {
        if ((element = element.strip()).startsWith("class") && element.endsWith("{")) {
            String[] elements = element.split(" ");
            this.name = elements[1];
            if (this.name.endsWith("{")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        } else if (element.equals("}")) {
            stack.remove(this);
        }
        for (Pair<Predicate<String>, BiFunction<String, ProviderClass, IStateHandler<String>>> multiHandler : handlers) {
            if (!multiHandler.getFirst().test(element)) continue;
            IStateHandler<String> layer = multiHandler.getSecond().apply(element, this);
            if (layer != null) {
                layer.trial(element, stack);
                stack.add(layer);
            }
            return;
        }
    }

    @Override
    public DocumentClass provide() {
        DocumentClass document = new DocumentClass();
        document.setName(this.name);
        ArrayList<IDecorative> decos = new ArrayList<IDecorative>();
        for (IDocumentProvider<?> provider : this.elements) {
            Object doc = provider.provide();
            if (doc instanceof IDecorative) {
                decos.add((IDecorative)doc);
                continue;
            }
            if (doc instanceof IConcrete) {
                ((IConcrete)doc).acceptDeco(decos.stream().toList());
            }
            decos.clear();
            document.acceptProperty((IDocument)doc);
        }
        return document;
    }

    public String getName() {
        return this.name;
    }
}

