/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.document.type;

import com.google.gson.JsonSyntaxException;
import com.probejs.ProbeJS;
import com.probejs.document.type.IType;
import com.probejs.document.type.TypeArray;
import com.probejs.document.type.TypeIntersection;
import com.probejs.document.type.TypeNamed;
import com.probejs.document.type.TypeObject;
import com.probejs.document.type.TypeParameterized;
import com.probejs.document.type.TypeUnion;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.TypeInfoArray;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.info.type.TypeInfoParameterized;
import com.probejs.info.type.TypeInfoVariable;
import com.probejs.info.type.TypeInfoWildcard;
import com.probejs.util.Pair;
import com.probejs.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class Resolver {
    public static IType resolveType(String type) {
        Pair<String, String> splitUnion = StringUtil.splitFirst(type = type.strip(), "<{", "}>", "|");
        if (splitUnion != null) {
            return new TypeUnion(Resolver.resolveType(splitUnion.getFirst()), Resolver.resolveType(splitUnion.getSecond()));
        }
        Pair<String, String> splitIntersection = StringUtil.splitFirst(type, "<{", "}>", "&");
        if (splitIntersection != null) {
            return new TypeIntersection(Resolver.resolveType(splitIntersection.getFirst()), Resolver.resolveType(splitIntersection.getSecond()));
        }
        if (type.endsWith("[]")) {
            return new TypeArray(Resolver.resolveType(type.substring(0, type.length() - 2)));
        }
        if (type.startsWith("{")) {
            HashMap<String, IType> membersMap = new HashMap<String, IType>();
            ProbeJS.LOGGER.info(type);
            List<String> members = StringUtil.splitLayer(type.substring(1, type.length() - 1), "<{", "}>", ",");
            for (String member : members) {
                Pair<String, String> pair = StringUtil.splitFirst(member, "[", "]", ":");
                if (pair == null) {
                    ProbeJS.LOGGER.warn("Failed to parse member: %s".formatted(member));
                    continue;
                }
                String memberName = pair.getFirst().strip();
                IType memberType = Resolver.resolveType(pair.getSecond().strip());
                if (memberName.startsWith("\"")) {
                    try {
                        memberName = (String)ProbeJS.GSON.fromJson(memberName, String.class);
                    }
                    catch (JsonSyntaxException e) {
                        ProbeJS.LOGGER.error(e.getMessage());
                    }
                }
                membersMap.put(memberName, memberType);
            }
            return new TypeObject(membersMap);
        }
        if (type.endsWith(">")) {
            int indexLeft = type.indexOf("<");
            String rawType = type.substring(0, indexLeft);
            String typeParams = type.substring(indexLeft + 1, type.length() - 1);
            List<String> params = StringUtil.splitLayer(typeParams, "<{", "}>", ",");
            return new TypeParameterized(Resolver.resolveType(rawType), params.stream().map(Resolver::resolveType).collect(Collectors.toList()));
        }
        return new TypeNamed(type);
    }

    public static boolean typeEquals(IType docType, ITypeInfo param) {
        if (docType instanceof TypeUnion || docType instanceof TypeIntersection) {
            return false;
        }
        if (docType instanceof TypeArray && param instanceof TypeInfoArray) {
            TypeInfoArray array = (TypeInfoArray)param;
            return Resolver.typeEquals(((TypeArray)docType).getComponent(), array.getBaseType());
        }
        if (docType instanceof TypeParameterized && param instanceof TypeInfoParameterized) {
            TypeInfoParameterized parameterized = (TypeInfoParameterized)param;
            List<ITypeInfo> paramInfo = parameterized.getParamTypes();
            List<IType> paramDoc = ((TypeParameterized)docType).getParamTypes();
            if (paramDoc.size() != paramInfo.size()) {
                return false;
            }
            for (int i = 0; i < paramDoc.size(); ++i) {
                if (Resolver.typeEquals(paramDoc.get(i), paramInfo.get(i))) continue;
                return false;
            }
            return Resolver.typeEquals(((TypeParameterized)docType).getRawType(), parameterized.getBaseType());
        }
        if (docType instanceof TypeNamed && (param instanceof TypeInfoVariable || param instanceof TypeInfoClass || param instanceof TypeInfoWildcard)) {
            return ((TypeNamed)docType).getRawTypeName().equals(param.getTypeName());
        }
        return false;
    }
}

