/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.EnumSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CapturedEvent {
    @Nonnull
    private final Class<? extends EventJS> captured;
    @Nullable
    private final String sub;
    @Nonnull
    private final String id;
    @Nonnull
    private final EnumSet<ScriptType> scriptTypes;
    private final boolean cancellable;

    public CapturedEvent(@Nonnull Class<? extends EventJS> captured, @Nonnull String id, @Nullable String sub, @Nonnull EnumSet<ScriptType> type, boolean cancellable) {
        this.captured = captured;
        this.sub = sub;
        this.id = id;
        this.scriptTypes = type;
        this.cancellable = cancellable;
    }

    public boolean hasSub() {
        return this.sub != null;
    }

    @Nullable
    public String getSub() {
        return this.sub;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public EnumSet<ScriptType> getScriptTypes() {
        return this.scriptTypes;
    }

    public String getFormattedTypeString() {
        return this.scriptTypes.stream().map(scriptType -> "**%s**".formatted(scriptType.name)).collect(Collectors.joining(", "));
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    @Nonnull
    public Class<? extends EventJS> getCaptured() {
        return this.captured;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("sub", this.sub);
        json.addProperty("class", this.getCaptured().getName());
        JsonArray types = new JsonArray();
        this.scriptTypes.forEach(script -> types.add(script.name()));
        json.add("type", (JsonElement)types);
        json.addProperty("cancellable", Boolean.valueOf(this.cancellable));
        return json;
    }

    public static Optional<CapturedEvent> fromJson(JsonObject json) {
        Class<?> clazz;
        String id = json.get("id").getAsString();
        try {
            clazz = Class.forName(json.get("class").getAsString());
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
        EnumSet<ScriptType> types = EnumSet.noneOf(ScriptType.class);
        if (json.has("type")) {
            JsonArray jArray = json.get("type").getAsJsonArray();
            jArray.forEach(jElement -> types.add(ScriptType.valueOf((String)jElement.getAsString())));
        }
        String sub = json.has("sub") ? json.get("sub").getAsString() : null;
        boolean cancellable = json.has("cancellable") && json.get("cancellable").getAsBoolean();
        return Optional.of(new CapturedEvent(clazz, id, sub, types, cancellable));
    }
}

