/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter;

import com.google.gson.Gson;
import com.probejs.ProbeJS;
import com.probejs.document.type.IType;
import com.probejs.document.type.TypeNamed;
import com.probejs.document.type.TypeParameterized;
import com.probejs.formatter.SpecialTypes;
import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.ClassWrapper;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.NativeObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.damagesource.DamageSource;

public class NameResolver {
    public static final HashMap<String, List<ResolvedName>> resolvedNames = new HashMap();
    public static final HashMap<Class<?>, List<IType>> specialExtension = new HashMap();
    public static final HashMap<Class<?>, Function<ITypeInfo, String>> specialTypeFormatters = new HashMap();
    public static final HashMap<Class<?>, Function<Object, String>> specialValueFormatters = new HashMap();
    public static final HashMap<Class<?>, Boolean> specialTypeGuards = new HashMap();
    public static final HashMap<Class<?>, Supplier<List<String>>> specialClassAssigner = new HashMap();
    public static final List<String> nameResolveSpecials = new ArrayList<String>();
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> resolvedPrimitives = new HashSet<String>();
    private static boolean initialized = false;

    public static void putResolvedName(String className, String resolvedName) {
        NameResolver.putResolvedName(className, new ResolvedName(Arrays.stream(resolvedName.split("\\.")).toList()));
    }

    public static void putResolvedName(String className, ResolvedName resolvedName) {
        resolvedNames.computeIfAbsent(className, s -> new ArrayList()).add(resolvedName);
    }

    public static void putResolvedName(Class<?> className, ResolvedName resolvedName) {
        String remappedName = MethodInfo.RUNTIME.getMappedClass(className);
        NameResolver.putResolvedName(remappedName, resolvedName);
    }

    public static void putResolvedName(Class<?> className, String resolvedName) {
        NameResolver.putResolvedName(className, new ResolvedName(Arrays.stream(resolvedName.split("\\.")).toList()));
    }

    @MethodsReturnNonnullByDefault
    public static ResolvedName getResolvedName(String className) {
        List<ResolvedName> names = resolvedNames.get(className);
        if (names == null || names.size() == 0) {
            return ResolvedName.UNRESOLVED;
        }
        return names.get(0);
    }

    public static void putTypeFormatter(Class<?> className, Function<ITypeInfo, String> formatter) {
        specialTypeFormatters.put(className, formatter);
    }

    public static void putTypeGuard(boolean isSafe, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            specialTypeGuards.put(clazz, isSafe);
        }
    }

    public static boolean isTypeSpecial(Class<?> clazz) {
        return specialTypeFormatters.containsKey(clazz);
    }

    public static void putValueFormatter(Function<Object, String> transformer, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            specialValueFormatters.put(clazz, transformer);
        }
    }

    public static String formatValue(Object object) {
        if (object == null) {
            return "null";
        }
        if (specialValueFormatters.containsKey(object.getClass())) {
            return specialValueFormatters.get(object.getClass()).apply(object);
        }
        for (Map.Entry<Class<?>, Function<Object, String>> entry : specialValueFormatters.entrySet()) {
            if (!entry.getKey().isAssignableFrom(object.getClass())) continue;
            return entry.getValue().apply(object);
        }
        return null;
    }

    public static boolean findResolvedName(ResolvedName name) {
        return resolvedNames.values().stream().anyMatch(names -> names.contains(name));
    }

    public static void resolveName(Class<?> clazz) {
        String remappedName = MethodInfo.RUNTIME.getMappedClass(clazz);
        if (resolvedNames.containsKey(remappedName)) {
            return;
        }
        ResolvedName resolved = new ResolvedName(Arrays.stream(remappedName.split("\\.")).toList());
        ResolvedName internal = new ResolvedName(List.of("Internal", resolved.getLastName()));
        if (NameResolver.findResolvedName(internal)) {
            NameResolver.putResolvedName(remappedName, resolved);
        } else {
            NameResolver.putResolvedName(remappedName, internal);
        }
    }

    public static void resolveNames(List<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            NameResolver.resolveName(clazz);
        }
    }

    public static void addKeyword(String kw) {
        keywords.add(kw);
    }

    public static String getNameSafe(String kw) {
        return keywords.contains(kw) ? kw + "_" : kw;
    }

    public static void putResolvedPrimitive(Class<?> clazz, String resolvedName) {
        NameResolver.putResolvedName(clazz, resolvedName);
        resolvedPrimitives.add(clazz.getName());
    }

    public static void putSpecialAssignments(Class<?> clazz, Supplier<List<String>> assigns) {
        specialClassAssigner.put(clazz, assigns);
    }

    public static List<String> getClassAssignments(Class<?> clazz) {
        return specialClassAssigner.getOrDefault(clazz, ArrayList::new).get();
    }

    public static void putSpecialExtension(Class<?> clazz, String base) {
        NameResolver.putSpecialExtension(clazz, new TypeNamed(base));
    }

    public static void putSpecialExtension(Class<?> clazz, IType type) {
        specialExtension.computeIfAbsent(clazz, c -> new ArrayList()).add(type);
    }

    public static void addPrioritizedPackage(String prior) {
        nameResolveSpecials.add(prior + ".");
    }

    public static List<Class<?>> priorSortClasses(Set<Class<?>> classes) {
        HashMap<Integer, List> partMap = new HashMap<Integer, List>();
        for (Class<?> clazz : classes) {
            int index = -1;
            String remappedName = MethodInfo.RUNTIME.getMappedClass(clazz);
            for (int i2 = 0; i2 < nameResolveSpecials.size(); ++i2) {
                if (!remappedName.startsWith(nameResolveSpecials.get(i2))) continue;
                index = i2;
            }
            partMap.computeIfAbsent(index, i -> new ArrayList()).add(clazz);
        }
        ArrayList result = new ArrayList();
        for (int i3 = 0; i3 < nameResolveSpecials.size(); ++i3) {
            if (!partMap.containsKey(i3)) continue;
            result.addAll((Collection)partMap.get(i3));
        }
        if (partMap.containsKey(-1)) {
            result.addAll((Collection)partMap.get(-1));
        }
        return result;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        NameResolver.putResolvedPrimitive(Object.class, "any");
        NameResolver.putResolvedPrimitive(String.class, "string");
        NameResolver.putResolvedPrimitive(Character.class, "string");
        NameResolver.putResolvedPrimitive(Character.TYPE, "string");
        NameResolver.putResolvedPrimitive(Void.class, "void");
        NameResolver.putResolvedPrimitive(Void.TYPE, "void");
        NameResolver.putResolvedPrimitive(Long.class, "number");
        NameResolver.putResolvedPrimitive(Long.TYPE, "number");
        NameResolver.putResolvedPrimitive(Integer.class, "number");
        NameResolver.putResolvedPrimitive(Integer.TYPE, "number");
        NameResolver.putResolvedPrimitive(Short.class, "number");
        NameResolver.putResolvedPrimitive(Short.TYPE, "number");
        NameResolver.putResolvedPrimitive(Byte.class, "number");
        NameResolver.putResolvedPrimitive(Byte.TYPE, "number");
        NameResolver.putResolvedPrimitive(Double.class, "number");
        NameResolver.putResolvedPrimitive(Double.TYPE, "number");
        NameResolver.putResolvedPrimitive(Float.class, "number");
        NameResolver.putResolvedPrimitive(Float.TYPE, "number");
        NameResolver.putResolvedPrimitive(Boolean.class, "boolean");
        NameResolver.putResolvedPrimitive(Boolean.TYPE, "boolean");
        NameResolver.putValueFormatter(arg_0 -> ((Gson)ProbeJS.GSON).toJson(arg_0), String.class, Character.class, Character.TYPE, Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Boolean.class, Boolean.TYPE);
        NameResolver.putValueFormatter(SpecialTypes::formatMap, Map.class);
        NameResolver.putValueFormatter(SpecialTypes::formatList, List.class);
        NameResolver.putValueFormatter(SpecialTypes::formatScriptable, NativeObject.class);
        NameResolver.putValueFormatter(SpecialTypes::formatFunction, BaseFunction.class);
        NameResolver.putValueFormatter(SpecialTypes::formatNJO, NativeJavaObject.class);
        NameResolver.putSpecialAssignments(DamageSource.class, () -> {
            ArrayList<String> result = new ArrayList<String>();
            try {
                for (Field field : DamageSource.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != DamageSource.class) continue;
                    result.add(ProbeJS.GSON.toJson((Object)((DamageSource)field.get(null)).m_19385_()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        });
        NameResolver.putSpecialAssignments(MaterialJS.class, () -> MaterialListJS.INSTANCE.map.keySet().stream().map(arg_0 -> ((Gson)ProbeJS.GSON).toJson(arg_0)).collect(Collectors.toList()));
        SpecialTypes.assignRegistries();
        NameResolver.putTypeFormatter(Class.class, SpecialTypes::formatClassLike);
        NameResolver.putTypeFormatter(ClassWrapper.class, SpecialTypes::formatClassLike);
        NameResolver.putTypeGuard(true, Class.class, ClassWrapper.class);
        NameResolver.putTypeGuard(false, IngredientJS.class);
        NameResolver.putSpecialExtension(List.class, new TypeParameterized(new TypeNamed("Array"), List.of(new TypeNamed("E"))));
        NameResolver.putSpecialExtension(AbstractMap.class, new TypeParameterized(new TypeNamed("TSDoc.JSMap"), List.of(new TypeNamed("K"), new TypeNamed("V"))));
        NameResolver.addKeyword("function");
        NameResolver.addKeyword("debugger");
        NameResolver.addKeyword("in");
        NameResolver.addKeyword("with");
        NameResolver.addKeyword("java");
        NameResolver.addKeyword("var");
        NameResolver.addKeyword("const");
        NameResolver.addPrioritizedPackage("java");
        NameResolver.addPrioritizedPackage("net.minecraft");
        NameResolver.addPrioritizedPackage("net.minecraftforge");
        NameResolver.addPrioritizedPackage("dev.latvian.mods");
    }

    public static class ResolvedName {
        public static final ResolvedName UNRESOLVED = new ResolvedName(List.of("any"));
        private final List<String> names;

        private ResolvedName(List<String> names) {
            this.names = names.stream().map(NameResolver::getNameSafe).collect(Collectors.toList());
        }

        public String getFullName() {
            return String.join((CharSequence)".", this.names);
        }

        public String getNamespace() {
            return String.join((CharSequence)".", this.names.subList(0, this.names.size() - 1));
        }

        public String getLastName() {
            return this.names.get(this.names.size() - 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedName that = (ResolvedName)o;
            return this.names.equals(that.names);
        }

        public int hashCode() {
            return Objects.hash(this.names);
        }

        public String toString() {
            return "ResolvedName{names=" + this.names + "}";
        }
    }
}

