/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter;

import com.mojang.serialization.Codec;
import com.probejs.ProbeJS;
import com.probejs.compiler.SpecialCompiler;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.clazz.FormatterClass;
import com.probejs.formatter.formatter.clazz.FormatterType;
import com.probejs.formatter.formatter.special.FormatterRegistry;
import com.probejs.info.ClassInfo;
import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.info.type.TypeInfoParameterized;
import com.probejs.info.type.TypeInfoVariable;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SpecialTypes {
    public static Set<Class<?>> skippedSpecials = new HashSet();

    public static void processFunctionalInterfaces(Set<Class<?>> globalClasses) {
        block0: for (Class<?> clazz : globalClasses) {
            ClassInfo info;
            if (!clazz.isInterface() || skippedSpecials.contains(clazz) || (info = ClassInfo.getOrCache(clazz)).getMethodInfo().stream().filter(MethodInfo::isAbstract).count() != 1L) continue;
            for (MethodInfo method : info.getMethodInfo()) {
                if (!method.isAbstract()) continue;
                FormatterLambda formatter = new FormatterLambda(method);
                NameResolver.putTypeFormatter(clazz, formatter::format);
                continue block0;
            }
        }
    }

    private static String formatValueOrType(Object obj) {
        String formattedValue = NameResolver.formatValue(obj);
        if (formattedValue == null) {
            String remappedName = MethodInfo.RUNTIME.getMappedClass(obj.getClass());
            if (!NameResolver.resolvedNames.containsKey(remappedName) && !remappedName.contains("$Lambda$")) {
                NameResolver.resolveName(obj.getClass());
            }
            formattedValue = FormatterClass.formatTypeParameterized(new TypeInfoClass((Type)obj.getClass()));
        }
        return formattedValue;
    }

    public static String formatMap(Object obj) {
        ArrayList<String> values = new ArrayList<String>();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                String formattedKey = NameResolver.formatValue(key);
                if (formattedKey == null) continue;
                String formattedValue = SpecialTypes.formatValueOrType(value);
                values.add("%s:%s".formatted(formattedKey, formattedValue));
            }
        }
        return "{%s}".formatted(String.join((CharSequence)",", values));
    }

    public static String formatClassLike(ITypeInfo obj) {
        ITypeInfo inner = null;
        if (obj instanceof TypeInfoParameterized) {
            TypeInfoParameterized cls = (TypeInfoParameterized)obj;
            inner = cls.getParamTypes().get(0);
        } else if (obj instanceof TypeInfoClass) {
            TypeInfoClass cls = (TypeInfoClass)obj;
            inner = cls;
        }
        if (inner == null) {
            return "any";
        }
        return "%s%s".formatted(inner.getResolvedClass().isInterface() ? "" : "typeof ", new FormatterType(inner.getBaseType(), false).format(0, 0));
    }

    public static String formatList(Object obj) {
        ArrayList<String> values = new ArrayList<String>();
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object o : list) {
                String formattedValue = NameResolver.formatValue(o);
                if (formattedValue == null) {
                    formattedValue = "undefined";
                }
                values.add(formattedValue);
            }
        }
        return "[%s]".formatted(String.join((CharSequence)", ", values));
    }

    public static String formatScriptable(Object obj) {
        ArrayList<String> values = new ArrayList<String>();
        if (obj instanceof ScriptableObject) {
            Object[] fun;
            String funName;
            ScriptableObject scriptable = (ScriptableObject)obj;
            Scriptable pt = scriptable.getPrototype();
            Object object = pt.get("constructor", pt);
            if (object instanceof BaseFunction && !(funName = (fun = (Object[])object).getFunctionName()).isEmpty() && !funName.equals("Object")) {
                return funName;
            }
            for (Object id : scriptable.getIds()) {
                String formattedKey = NameResolver.formatValue(id);
                Object value = id instanceof Number ? scriptable.get(((Integer)id).intValue(), (Scriptable)scriptable) : scriptable.get((String)id, (Scriptable)scriptable);
                String formattedValue = SpecialTypes.formatValueOrType(value);
                values.add("%s:%s".formatted(formattedKey, formattedValue));
            }
            Scriptable proto = scriptable.getPrototype();
            for (Object id : proto.getIds()) {
                String formattedKey = NameResolver.formatValue(id);
                Object value = id instanceof Number ? proto.get(((Integer)id).intValue(), (Scriptable)scriptable) : proto.get((String)id, (Scriptable)scriptable);
                String formattedValue = SpecialTypes.formatValueOrType(value);
                values.add("%s:%s".formatted(formattedKey, formattedValue));
            }
        }
        return "{%s}".formatted(String.join((CharSequence)",", values));
    }

    public static String formatFunction(Object obj) {
        if (obj instanceof BaseFunction) {
            BaseFunction function = (BaseFunction)obj;
            return "(%s) => any".formatted(IntStream.range(0, function.getLength()).mapToObj(arg_0 -> SpecialTypes.lambda$formatFunction$0("arg%s", arg_0)).collect(Collectors.joining(", ")));
        }
        return null;
    }

    public static String formatNJO(Object obj) {
        if (obj instanceof NativeJavaObject) {
            NativeJavaObject njo = (NativeJavaObject)obj;
            return SpecialTypes.formatValueOrType(njo.unwrap());
        }
        return null;
    }

    public static <T> void assignRegistry(Class<T> clazz, ResourceKey<Registry<T>> registry) {
        SpecialCompiler.specialCompilers.add(new FormatterRegistry<T>(registry, clazz));
        List remappedName = Arrays.stream(MethodInfo.RUNTIME.getMappedClass(clazz).split("\\.")).collect(Collectors.toList());
        NameResolver.putSpecialAssignments(clazz, () -> List.of("Special.%s".formatted(remappedName.get(remappedName.size() - 1))));
    }

    public static <T> void assignRegistries() {
        for (Field field : Registry.class.getFields()) {
            if (field.getType() != ResourceKey.class || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                Class<?> clazz;
                ResourceKey key = (ResourceKey)field.get(null);
                Type type = field.getGenericType();
                Type type1 = ((ParameterizedType)type).getActualTypeArguments()[0];
                Type type2 = ((ParameterizedType)type1).getActualTypeArguments()[0];
                ITypeInfo typeInfo = InfoTypeResolver.resolveType(type2);
                if (typeInfo == null || (clazz = typeInfo.getResolvedClass()) == ResourceLocation.class || clazz == ResourceKey.class || clazz == Codec.class) continue;
                SpecialTypes.assignRegistry(clazz, key);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ProbeJS.LOGGER.error("Can not touch field: %s of %s".formatted(field.getName(), field.getDeclaringClass()));
            }
        }
    }

    private static /* synthetic */ String lambda$formatFunction$0(String rec$, Object xva$0) {
        return "arg%s".formatted(xva$0);
    }

    private static class FormatterLambda {
        private final MethodInfo info;

        private FormatterLambda(MethodInfo info) {
            this.info = info;
        }

        public String format(ITypeInfo typeInfo) {
            HashMap<String, TypeInfoClass> variableMap = new HashMap<String, TypeInfoClass>();
            if (typeInfo instanceof TypeInfoParameterized) {
                TypeInfoParameterized parameterized = (TypeInfoParameterized)typeInfo;
                ArrayList<ITypeInfo> concreteTypes = new ArrayList<ITypeInfo>(parameterized.getParamTypes());
                for (ITypeInfo variable : this.info.getFrom().getParameters()) {
                    variableMap.put(variable.getTypeName(), (TypeInfoClass)(concreteTypes.isEmpty() ? new TypeInfoClass((Type)((Object)Object.class)) : (ITypeInfo)concreteTypes.remove(0)));
                }
            }
            ArrayList<String> formattedParam = new ArrayList<String>();
            for (MethodInfo.ParamInfo param : this.info.getParams()) {
                ITypeInfo resolvedType = param.getType();
                if (resolvedType instanceof TypeInfoVariable) {
                    resolvedType = variableMap.getOrDefault(resolvedType.getTypeName(), new TypeInfoClass((Type)((Object)Object.class)));
                }
                formattedParam.add("%s: %s".formatted(param.getName(), new FormatterType(resolvedType, false).format(0, 0)));
            }
            ITypeInfo resolvedReturn = this.info.getReturnType();
            if (resolvedReturn instanceof TypeInfoVariable) {
                resolvedReturn = variableMap.getOrDefault(resolvedReturn.getTypeName(), new TypeInfoClass((Type)((Object)Object.class)));
            }
            return "((%s) => %s)".formatted(String.join((CharSequence)", ", formattedParam), new FormatterType(resolvedReturn, false).format(0, 0));
        }
    }
}

