/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter.formatter.clazz;

import com.google.gson.Gson;
import com.probejs.ProbeConfig;
import com.probejs.ProbeJS;
import com.probejs.document.DocumentClass;
import com.probejs.document.DocumentComment;
import com.probejs.document.DocumentField;
import com.probejs.document.DocumentMethod;
import com.probejs.document.Manager;
import com.probejs.document.comment.special.CommentHidden;
import com.probejs.document.type.IType;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.DocumentReceiver;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.formatter.formatter.clazz.FormatterConstructor;
import com.probejs.formatter.formatter.clazz.FormatterField;
import com.probejs.formatter.formatter.clazz.FormatterMethod;
import com.probejs.formatter.formatter.clazz.FormatterType;
import com.probejs.info.ClassInfo;
import com.probejs.info.FieldInfo;
import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.info.type.TypeInfoParameterized;
import dev.latvian.mods.rhino.util.EnumTypeWrapper;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FormatterClass
extends DocumentReceiver<DocumentClass>
implements IFormatter {
    private final ClassInfo classInfo;
    private final Map<String, FormatterField> fieldFormatters = new HashMap<String, FormatterField>();
    private final Map<String, List<FormatterMethod>> methodFormatters = new HashMap<String, List<FormatterMethod>>();
    private final List<DocumentField> fieldAdditions = new ArrayList<DocumentField>();
    private final List<DocumentMethod> methodAdditions = new ArrayList<DocumentMethod>();
    private boolean internal = false;

    public FormatterClass(ClassInfo classInfo) {
        this.classInfo = classInfo;
        classInfo.getMethodInfo().forEach(methodInfo -> this.methodFormatters.computeIfAbsent(methodInfo.getName(), s -> new ArrayList()).add(new FormatterMethod((MethodInfo)methodInfo)));
        classInfo.getFieldInfo().forEach(fieldInfo -> this.fieldFormatters.put(fieldInfo.getName(), new FormatterField((FieldInfo)fieldInfo)));
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    private List<String> fetchAdditionalComments(Integer indent) {
        ArrayList<String> comments = new ArrayList<String>();
        comments.add("%s* @javaClass %s".formatted(" ".repeat(indent), this.classInfo.getClazzRaw().getName()));
        return comments;
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        List<ITypeInfo> params;
        String extensions;
        DocumentComment comment;
        ArrayList<String> formatted = new ArrayList<String>();
        DocumentComment documentComment = comment = this.document == null ? null : ((DocumentClass)this.document).getComment();
        if (comment != null) {
            if (comment.getSpecialComment(CommentHidden.class) != null) {
                return formatted;
            }
            formattedText = comment.format(indent, stepIndent);
            formattedText.addAll(formattedText.size() - 1, this.fetchAdditionalComments(indent));
            formatted.addAll(formattedText);
        } else {
            formattedText = new ArrayList<String>();
            formattedText.add("%s/**".formatted(" ".repeat(indent)));
            formattedText.addAll(this.fetchAdditionalComments(indent));
            formattedText.add("%s*/".formatted(" ".repeat(indent)));
            formatted.addAll(formattedText);
        }
        List assignableTypes = ((List)Manager.typesAssignable.getOrDefault(this.classInfo.getName(), new ArrayList())).stream().map(IType::getTypeName).collect(Collectors.toList());
        assignableTypes.addAll(NameResolver.getClassAssignments(this.classInfo.getClazzRaw()));
        if (this.classInfo.isEnum()) {
            Class<?> clazz = this.classInfo.getClazzRaw();
            EnumTypeWrapper enumWrapper = EnumTypeWrapper.get(clazz);
            enumWrapper.nameValues.keySet().stream().map(arg_0 -> ((Gson)ProbeJS.GSON).toJson(arg_0)).forEach(assignableTypes::add);
        }
        ArrayList<Object> firstLine = new ArrayList<Object>();
        if (!this.internal) {
            firstLine.add("declare");
        }
        if (this.classInfo.isAbstract() && !this.classInfo.isInterface()) {
            firstLine.add("abstract");
        }
        if (this.classInfo.isInterface()) {
            firstLine.add("interface");
        } else {
            firstLine.add("class");
        }
        firstLine.add(NameResolver.getResolvedName(this.classInfo.getName()).getLastName());
        if (this.classInfo.getClazzRaw().getTypeParameters().length != 0) {
            firstLine.add("<%s>".formatted(Arrays.stream(this.classInfo.getClazzRaw().getTypeParameters()).map(TypeVariable::getName).collect(Collectors.joining(", "))));
        }
        if (this.classInfo.getSuperClass() != null) {
            firstLine.add("extends");
            firstLine.add(FormatterClass.formatTypeParameterized(InfoTypeResolver.resolveType(this.classInfo.getClazzRaw().getGenericSuperclass())));
            if (NameResolver.specialExtension.containsKey(this.classInfo.getClazzRaw()) && !(extensions = NameResolver.specialExtension.get(this.classInfo.getClazzRaw()).stream().map(IType::getTypeName).collect(Collectors.joining(", "))).isEmpty()) {
                firstLine.add("," + extensions);
            }
        }
        if (!this.classInfo.getInterfaces().isEmpty()) {
            firstLine.add(this.classInfo.isInterface() ? "extends" : "implements");
            firstLine.add("%s".formatted(Arrays.stream(this.classInfo.getClazzRaw().getGenericInterfaces()).map(InfoTypeResolver::resolveType).map(FormatterClass::formatTypeParameterized).collect(Collectors.joining(", "))));
            if (NameResolver.specialExtension.containsKey(this.classInfo.getClazzRaw()) && !(extensions = NameResolver.specialExtension.get(this.classInfo.getClazzRaw()).stream().map(IType::getTypeName).collect(Collectors.joining(", "))).isEmpty() && this.classInfo.isInterface()) {
                firstLine.add("," + extensions);
            }
        }
        firstLine.add("{");
        formatted.add(" ".repeat(indent) + String.join((CharSequence)" ", firstLine));
        HashSet formattedMethods = new HashSet();
        this.methodFormatters.values().forEach(m -> m.stream().filter(mf -> ProbeConfig.INSTANCE.dumpMethod || mf.getBean() == null || this.fieldFormatters.containsKey(mf.getBean()) || this.methodFormatters.containsKey(mf.getBean())).forEach(mf -> {
            if (this.classInfo.isInterface() && mf.getMethodInfo().isStatic() && this.internal) {
                return;
            }
            List<String> formattedMethod = mf.format(indent + stepIndent, stepIndent);
            if (!formattedMethods.contains(formattedMethod)) {
                formatted.addAll(formattedMethod);
                formattedMethods.add(formattedMethod);
            }
        }));
        this.fieldFormatters.entrySet().stream().filter(e -> !this.methodFormatters.containsKey(e.getKey())).forEach(f -> {
            if (this.classInfo.isInterface() && ((FormatterField)f.getValue()).getFieldInfo().isStatic() && this.internal) {
                return;
            }
            ((FormatterField)f.getValue()).setInterface(this.classInfo.isInterface());
            formatted.addAll(((FormatterField)f.getValue()).format(indent + stepIndent, stepIndent));
        });
        if (!this.classInfo.isInterface()) {
            HashMap<String, FormatterMethod> getterMap = new HashMap<String, FormatterMethod>();
            HashMap<String, List> setterMap = new HashMap<String, List>();
            this.methodFormatters.values().forEach(ml -> ml.forEach(m -> {
                String beanName = m.getBean();
                if (beanName != null && Character.isAlphabetic(beanName.charAt(0)) && !this.fieldFormatters.containsKey(beanName) && !this.methodFormatters.containsKey(beanName)) {
                    if (m.isGetter()) {
                        getterMap.put(beanName, (FormatterMethod)m);
                    } else {
                        setterMap.computeIfAbsent(beanName, s -> new ArrayList()).add(m);
                    }
                }
            }));
            getterMap.forEach((k, v) -> formatted.addAll(v.formatBean(indent + stepIndent, stepIndent)));
            setterMap.forEach((k, v) -> {
                Optional<FormatterMethod> result = v.stream().filter(m -> !getterMap.containsKey(m.getBean()) || ((FormatterMethod)getterMap.get(m.getBean())).getBeanTypeString().equals(m.getBeanTypeString())).findFirst();
                result.ifPresent(formatterMethod -> formatted.addAll(formatterMethod.formatBean(indent + stepIndent, stepIndent)));
            });
        }
        if (!this.classInfo.isInterface()) {
            if (this.internal) {
                formatted.add(" ".repeat(indent + stepIndent) + "/**");
                formatted.add(" ".repeat(indent + stepIndent) + "* Internal constructor, this means that it's not valid and you will get an error if you use it.");
                formatted.add(" ".repeat(indent + stepIndent) + "*/");
                formatted.add(" ".repeat(indent + stepIndent) + "protected constructor();");
            } else {
                this.classInfo.getConstructorInfo().stream().map(FormatterConstructor::new).forEach(f -> formatted.addAll(f.format(indent + stepIndent, stepIndent)));
            }
        }
        this.fieldAdditions.forEach(fieldDoc -> formatted.addAll(fieldDoc.format(indent + stepIndent, stepIndent)));
        this.methodAdditions.forEach(methodDoc -> formatted.addAll(methodDoc.format(indent + stepIndent, stepIndent)));
        formatted.add(" ".repeat(indent) + "}");
        String underName = NameResolver.getResolvedName(this.classInfo.getName()).getLastName() + "_";
        Object origName = NameResolver.getResolvedName(this.classInfo.getName()).getLastName();
        if (NameResolver.specialTypeFormatters.containsKey(this.classInfo.getClazzRaw())) {
            assignableTypes.add(new FormatterType(new TypeInfoParameterized(new TypeInfoClass((Type)this.classInfo.getClazzRaw()), this.classInfo.getParameters())).format(0, 0));
        }
        if ((params = this.classInfo.getParameters()).size() > 0) {
            String paramString = "<%s>".formatted(params.stream().map(ITypeInfo::getTypeName).collect(Collectors.joining(", ")));
            underName = underName + paramString;
            origName = (String)origName + paramString;
        }
        assignableTypes.add(origName);
        if (comment != null) {
            formatted.addAll(comment.format(indent, stepIndent));
        }
        formatted.add(" ".repeat(indent) + "type %s = %s;".formatted(underName, String.join((CharSequence)" | ", assignableTypes)));
        return formatted;
    }

    @Override
    public void addDocument(DocumentClass document) {
        super.addDocument(document);
        document.getFields().forEach(documentField -> {
            if (this.fieldFormatters.containsKey(documentField.getName())) {
                this.fieldFormatters.get(documentField.getName()).addDocument(documentField);
            } else {
                this.fieldAdditions.add((DocumentField)documentField);
            }
        });
        document.getMethods().forEach(documentMethod -> {
            if (this.methodFormatters.containsKey(documentMethod.getName())) {
                this.methodFormatters.get(documentMethod.getName()).forEach(formatterMethod -> {
                    if (documentMethod.testMethod(formatterMethod.getMethodInfo())) {
                        formatterMethod.addDocument(documentMethod);
                    }
                });
            } else {
                this.methodAdditions.add((DocumentMethod)documentMethod);
            }
        });
    }

    public static String formatTypeParameterized(ITypeInfo info) {
        TypeInfoClass clazz;
        StringBuilder sb = new StringBuilder(new FormatterType(info, false).format(0, 0));
        if (info instanceof TypeInfoClass && (clazz = (TypeInfoClass)info).getTypeVariables().size() != 0) {
            sb.append("<%s>".formatted(String.join((CharSequence)", ", Collections.nCopies(clazz.getTypeVariables().size(), "any"))));
        }
        return sb.toString();
    }
}

