/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter.formatter.clazz;

import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.formatter.formatter.clazz.FormatterType;
import com.probejs.info.ClassInfo;
import com.probejs.info.ConstructorInfo;
import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.TypeInfoClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FormatterConstructor
implements IFormatter {
    private final ConstructorInfo constructor;

    public FormatterConstructor(ConstructorInfo constructor) {
        this.constructor = constructor;
    }

    private String formatTypeParameterized(ITypeInfo info) {
        TypeInfoClass clazz;
        ClassInfo classInfo;
        StringBuilder sb = new StringBuilder(new FormatterType(info).format(0, 0));
        if (info instanceof TypeInfoClass && (classInfo = ClassInfo.getOrCache((clazz = (TypeInfoClass)info).getResolvedClass())).getParameters().size() != 0) {
            sb.append("<%s>".formatted(String.join((CharSequence)", ", Collections.nCopies(classInfo.getParameters().size(), "any"))));
        }
        return sb.toString();
    }

    private String formatParams() {
        List<MethodInfo.ParamInfo> params = this.constructor.getParams();
        ArrayList<String> paramStrings = new ArrayList<String>();
        for (MethodInfo.ParamInfo param : params) {
            paramStrings.add("%s: %s".formatted(NameResolver.getNameSafe(param.getName()), this.formatTypeParameterized(param.getType())));
        }
        return String.join((CharSequence)", ", paramStrings);
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        ArrayList<String> formatted = new ArrayList<String>();
        formatted.add(" ".repeat(indent) + "constructor(%s);".formatted(this.formatParams()));
        return formatted;
    }
}

