/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter.formatter.clazz;

import com.probejs.ProbeJS;
import com.probejs.document.DocumentComment;
import com.probejs.document.DocumentField;
import com.probejs.document.comment.special.CommentHidden;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.DocumentReceiver;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.formatter.formatter.clazz.FormatterType;
import com.probejs.info.FieldInfo;
import com.probejs.info.type.InfoTypeResolver;
import java.util.ArrayList;
import java.util.List;

public class FormatterField
extends DocumentReceiver<DocumentField>
implements IFormatter {
    private final FieldInfo fieldInfo;
    private boolean isInterface = false;

    public FormatterField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public void setInterface(boolean anInterface) {
        this.isInterface = anInterface;
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        String fieldName;
        DocumentComment comment;
        ArrayList<String> formatted = new ArrayList<String>();
        DocumentComment documentComment = comment = this.document != null ? ((DocumentField)this.document).getComment() : null;
        if (comment != null) {
            if (comment.getSpecialComment(CommentHidden.class) != null) {
                return formatted;
            }
            formatted.addAll(comment.format(indent, stepIndent));
        }
        ArrayList<String> elements = new ArrayList<String>();
        if (this.fieldInfo.isStatic() && !this.isInterface) {
            elements.add("static");
        }
        if (this.fieldInfo.isFinal()) {
            elements.add("readonly");
        }
        if (!(fieldName = this.fieldInfo.getName()).matches("^[\\\\w.]+$")) {
            fieldName = ProbeJS.GSON.toJson((Object)fieldName);
        }
        elements.add(fieldName);
        elements.add(":");
        if (this.document != null) {
            elements.add(((DocumentField)this.document).getType().getTypeName());
        } else if (this.fieldInfo.isStatic() && NameResolver.formatValue(this.fieldInfo.getStaticValue()) != null) {
            elements.add(NameResolver.formatValue(this.fieldInfo.getStaticValue()));
        } else {
            elements.add(new FormatterType(this.fieldInfo.getType(), NameResolver.specialTypeGuards.getOrDefault(InfoTypeResolver.getContainedTypeOrSelf(this.fieldInfo.getType()).getResolvedClass(), true)).format(0, 0));
        }
        formatted.add(" ".repeat(indent) + String.join((CharSequence)" ", elements) + ";");
        return formatted;
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }
}

