/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter.formatter.clazz;

import com.probejs.document.DocumentComment;
import com.probejs.document.DocumentMethod;
import com.probejs.document.comment.CommentUtil;
import com.probejs.document.comment.special.CommentReturns;
import com.probejs.document.type.IType;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.DocumentReceiver;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.formatter.formatter.clazz.FormatterType;
import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.util.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormatterMethod
extends DocumentReceiver<DocumentMethod>
implements IFormatter {
    private final MethodInfo methodInfo;

    private static String getCamelCase(String text) {
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }

    public FormatterMethod(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public String getBean() {
        String methodName = this.methodInfo.getName();
        if (methodName.equals("is") || methodName.equals("get") || methodName.equals("set")) {
            return null;
        }
        if (methodName.startsWith("is") && this.methodInfo.getParams().size() == 0 && (this.methodInfo.getReturnType().assignableFrom(new TypeInfoClass((Type)((Object)Boolean.class))) || this.methodInfo.getReturnType().assignableFrom(new TypeInfoClass((Type)Boolean.TYPE)))) {
            return FormatterMethod.getCamelCase(methodName.substring(2));
        }
        if (methodName.startsWith("get") && this.methodInfo.getParams().size() == 0) {
            return FormatterMethod.getCamelCase(methodName.substring(3));
        }
        if (methodName.startsWith("set") && this.methodInfo.getParams().size() == 1) {
            return FormatterMethod.getCamelCase(methodName.substring(3));
        }
        return null;
    }

    public boolean isGetter() {
        return !this.methodInfo.getName().startsWith("set");
    }

    public String getBeanTypeString() {
        return this.isGetter() ? this.methodInfo.getReturnType().getTypeName() : this.methodInfo.getParams().get(0).getType().getTypeName();
    }

    private Pair<Map<String, IType>, IType> getModifiers() {
        DocumentComment comment;
        HashMap<String, IType> modifiers = new HashMap<String, IType>();
        IType returns = null;
        if (this.document != null && (comment = ((DocumentMethod)this.document).getComment()) != null) {
            modifiers.putAll(CommentUtil.getTypeModifiers(comment));
            CommentReturns r = comment.getSpecialComment(CommentReturns.class);
            if (r != null) {
                returns = r.getReturnType();
            }
        }
        return new Pair(modifiers, returns);
    }

    private static String formatTypeParameterized(ITypeInfo info, boolean useSpecial) {
        TypeInfoClass clazz;
        StringBuilder sb = new StringBuilder(new FormatterType(info, useSpecial).format(0, 0));
        if (info instanceof TypeInfoClass && !NameResolver.isTypeSpecial((clazz = (TypeInfoClass)info).getResolvedClass()) && clazz.getTypeVariables().size() != 0) {
            sb.append("<%s>".formatted(String.join((CharSequence)", ", Collections.nCopies(clazz.getTypeVariables().size(), "any"))));
        }
        return sb.toString();
    }

    private String formatReturn() {
        TypeInfoClass clsInfo;
        ITypeInfo returnType = this.methodInfo.getReturnType();
        if (returnType instanceof TypeInfoClass && (clsInfo = (TypeInfoClass)returnType).getResolvedClass() == this.methodInfo.getFrom().getClazzRaw()) {
            return "this";
        }
        return FormatterMethod.formatTypeParameterized(this.methodInfo.getReturnType(), NameResolver.specialTypeGuards.getOrDefault(this.methodInfo.getReturnType().getResolvedClass(), false));
    }

    public static String formatParamUnderscore(ITypeInfo info) {
        TypeInfoClass clazz;
        StringBuilder sb = new StringBuilder(new FormatterType(info, false, (typeInfo, rawString) -> {
            TypeInfoClass classInfo;
            if (typeInfo instanceof TypeInfoClass && !NameResolver.resolvedPrimitives.contains((classInfo = (TypeInfoClass)typeInfo).getTypeName()) && !rawString.equals("any")) {
                return rawString + "_";
            }
            return rawString;
        }).format(0, 0));
        if (info instanceof TypeInfoClass && (clazz = (TypeInfoClass)info).getTypeVariables().size() != 0) {
            sb.append("<%s>".formatted(String.join((CharSequence)", ", Collections.nCopies(clazz.getTypeVariables().size(), "any"))));
        }
        return sb.toString();
    }

    private static String formatParamDoc(Map<String, IType> modifiers, MethodInfo.ParamInfo paramInfo) {
        IType type = modifiers.get(paramInfo.getName());
        return type.getTypeName();
    }

    private String formatParams(Map<String, IType> modifiers, Map<String, String> renames) {
        return "(%s)".formatted(this.methodInfo.getParams().stream().map(paramInfo -> "%s: %s".formatted((paramInfo.isVararg() ? "... " : "") + NameResolver.getNameSafe(renames.getOrDefault(paramInfo.getName(), paramInfo.getName())), modifiers.containsKey(paramInfo.getName()) ? FormatterMethod.formatParamDoc(modifiers, paramInfo) : FormatterMethod.formatParamUnderscore(paramInfo.getType()))).collect(Collectors.joining(", ")));
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        ArrayList<String> formatted = new ArrayList<String>();
        if (this.document != null) {
            DocumentComment comment = ((DocumentMethod)this.document).getComment();
            if (CommentUtil.isHidden(comment)) {
                return formatted;
            }
            if (comment != null) {
                formatted.addAll(comment.format(indent, stepIndent));
            }
        }
        Pair<Map<String, IType>, IType> modifierPair = this.getModifiers();
        Map<String, IType> modifiers = modifierPair.getFirst();
        IType returnModifier = modifierPair.getSecond();
        HashMap<String, String> renames = new HashMap<String, String>();
        if (this.document != null) {
            renames.putAll(CommentUtil.getRenames(((DocumentMethod)this.document).getComment()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ".repeat(indent));
        if (this.methodInfo.isStatic()) {
            sb.append("static ");
        }
        sb.append(this.methodInfo.getName());
        if (this.methodInfo.getTypeVariables().size() != 0) {
            sb.append("<%s>".formatted(this.methodInfo.getTypeVariables().stream().map(ITypeInfo::getTypeName).collect(Collectors.joining(", "))));
        }
        sb.append(this.formatParams(modifiers, renames));
        sb.append(": %s;".formatted(returnModifier != null ? returnModifier.getTypeName() : this.formatReturn()));
        formatted.add(sb.toString());
        return formatted;
    }

    public List<String> formatBean(Integer indent, Integer stepIndent) {
        ArrayList<String> formatted = new ArrayList<String>();
        String methodName = this.methodInfo.getName();
        Pair<Map<String, IType>, IType> modifierPair = this.getModifiers();
        Map<String, IType> paramModifiers = modifierPair.getFirst();
        IType returnModifier = modifierPair.getSecond();
        if (this.document != null) {
            DocumentComment comment = ((DocumentMethod)this.document).getComment();
            if (CommentUtil.isHidden(comment)) {
                return formatted;
            }
            if (comment != null) {
                formatted.addAll(comment.format(indent, stepIndent));
            }
        }
        if (methodName.startsWith("is")) {
            formatted.add(" ".repeat(indent) + "get %s(): boolean;".formatted(this.getBean()));
        }
        if (methodName.startsWith("get")) {
            formatted.add(" ".repeat(indent) + "get %s(): %s;".formatted(this.getBean(), returnModifier == null ? this.formatReturn() : returnModifier.getTypeName()));
        }
        if (methodName.startsWith("set")) {
            MethodInfo.ParamInfo info = this.methodInfo.getParams().get(0);
            String name = info.getName();
            formatted.add(" ".repeat(indent) + "set %s%s;".formatted(this.getBean(), this.formatParams(paramModifiers, new HashMap<String, String>())));
        }
        return formatted;
    }
}

