/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter.formatter.clazz;

import com.probejs.formatter.NameResolver;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.TypeInfoArray;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.info.type.TypeInfoParameterized;
import com.probejs.info.type.TypeInfoVariable;
import com.probejs.info.type.TypeInfoWildcard;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class FormatterType {
    private final ITypeInfo typeInfo;
    private final boolean useSpecial;
    private final BiFunction<ITypeInfo, String, String> transformer;

    public FormatterType(ITypeInfo typeInfo, boolean useSpecial, BiFunction<ITypeInfo, String, String> transformer) {
        this.typeInfo = typeInfo;
        this.useSpecial = useSpecial;
        this.transformer = transformer;
    }

    public FormatterType(ITypeInfo typeInfo, boolean useSpecial) {
        this(typeInfo, useSpecial, (t, s) -> s);
    }

    public FormatterType(ITypeInfo typeInfo) {
        this(typeInfo, true);
    }

    public String format(Integer indent, Integer stepIndent) {
        Class<?> rawClass;
        if (this.useSpecial && NameResolver.specialTypeFormatters.containsKey(rawClass = this.typeInfo.getResolvedClass())) {
            return NameResolver.specialTypeFormatters.get(rawClass).apply(this.typeInfo);
        }
        if (this.typeInfo instanceof TypeInfoClass) {
            return this.transformer.apply(this.typeInfo, NameResolver.getResolvedName(this.typeInfo.getTypeName()).getFullName());
        }
        if (this.typeInfo instanceof TypeInfoWildcard) {
            return this.transformer.apply(this.typeInfo, new FormatterType(this.typeInfo.getBaseType(), this.useSpecial, this.transformer).format(indent, stepIndent));
        }
        if (this.typeInfo instanceof TypeInfoVariable) {
            return this.transformer.apply(this.typeInfo, this.typeInfo.getTypeName());
        }
        if (this.typeInfo instanceof TypeInfoArray) {
            return this.transformer.apply(this.typeInfo, new FormatterType(this.typeInfo.getBaseType(), this.useSpecial, this.transformer).format(indent, stepIndent) + "[]");
        }
        ITypeInfo iTypeInfo = this.typeInfo;
        if (iTypeInfo instanceof TypeInfoParameterized) {
            TypeInfoParameterized parType = (TypeInfoParameterized)iTypeInfo;
            if (new FormatterType(parType.getBaseType(), this.useSpecial, this.transformer).format(0, 0).equals("any")) {
                return this.transformer.apply(this.typeInfo, NameResolver.ResolvedName.UNRESOLVED.getFullName());
            }
            return this.transformer.apply(this.typeInfo, new FormatterType(parType.getBaseType(), this.useSpecial, this.transformer).format(indent, stepIndent) + "<%s>".formatted(parType.getParamTypes().stream().map(p -> new FormatterType((ITypeInfo)p, this.useSpecial, this.transformer).format(indent, stepIndent)).collect(Collectors.joining(", "))));
        }
        return "any";
    }
}

