/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info;

import com.probejs.ProbeJS;
import com.probejs.formatter.ClassResolver;
import com.probejs.info.ConstructorInfo;
import com.probejs.info.FieldInfo;
import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassInfo {
    public static final Map<Class<?>, ClassInfo> CLASS_CACHE = new HashMap();
    private final Class<?> clazzRaw;
    private final String name;
    private final int modifiers;
    private final boolean isInterface;
    private final List<ITypeInfo> parameters;
    private final List<MethodInfo> methodInfo;
    private final List<FieldInfo> fieldInfo;
    private final List<ConstructorInfo> constructorInfo;
    private final ClassInfo superClass;
    private final List<ClassInfo> interfaces;

    public static ClassInfo getOrCache(Class<?> clazz) {
        if (CLASS_CACHE.containsKey(clazz)) {
            return CLASS_CACHE.get(clazz);
        }
        ClassInfo info = new ClassInfo(clazz);
        CLASS_CACHE.put(clazz, info);
        return info;
    }

    private ClassInfo(Class<?> clazz) {
        this.clazzRaw = clazz;
        this.name = MethodInfo.RUNTIME.getMappedClass(this.clazzRaw);
        this.modifiers = this.clazzRaw.getModifiers();
        this.isInterface = this.clazzRaw.isInterface();
        this.superClass = this.clazzRaw.getSuperclass() == Object.class || this.clazzRaw.getSuperclass() == null ? null : ClassInfo.getOrCache(this.clazzRaw.getSuperclass());
        this.interfaces = Arrays.stream(this.clazzRaw.getInterfaces()).map(ClassInfo::getOrCache).collect(Collectors.toList());
        this.parameters = Arrays.stream(this.clazzRaw.getTypeParameters()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
        List<Object> conInfo = new ArrayList();
        try {
            conInfo = Arrays.stream(this.clazzRaw.getConstructors()).map(ConstructorInfo::new).collect(Collectors.toList());
        }
        catch (Error | Exception e) {
            ProbeJS.LOGGER.warn("Unable to access constructors of class %s".formatted(this.name));
        }
        this.constructorInfo = conInfo;
        List<MethodInfo> metInfo = new ArrayList<MethodInfo>();
        try {
            metInfo = Arrays.stream(this.clazzRaw.getMethods()).filter(m -> !m.isSynthetic()).filter(m -> m.getDeclaringClass() == clazz).map(m -> new MethodInfo((Method)m, clazz)).filter(m -> ClassResolver.acceptMethod(m.getName())).filter(m -> !m.shouldHide()).collect(Collectors.toList());
        }
        catch (Error | Exception e) {
            ProbeJS.LOGGER.warn("Unable to access methods of class %s".formatted(this.name));
        }
        this.methodInfo = metInfo;
        List<FieldInfo> fldInfo = new ArrayList<FieldInfo>();
        try {
            fldInfo = Arrays.stream(this.clazzRaw.getFields()).filter(f -> f.getDeclaringClass() == clazz).map(FieldInfo::new).filter(f -> ClassResolver.acceptField(f.getName())).filter(f -> !f.shouldHide()).filter(f -> !f.isTransient()).collect(Collectors.toList());
        }
        catch (Error | Exception e) {
            ProbeJS.LOGGER.warn("Unable to access fields of class %s".formatted(this.name));
        }
        this.fieldInfo = fldInfo;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public ClassInfo getSuperClass() {
        return this.superClass;
    }

    public List<ClassInfo> getInterfaces() {
        return this.interfaces;
    }

    public List<FieldInfo> getFieldInfo() {
        return this.fieldInfo;
    }

    public List<ConstructorInfo> getConstructorInfo() {
        return this.constructorInfo;
    }

    public List<MethodInfo> getMethodInfo() {
        return this.methodInfo;
    }

    public List<ITypeInfo> getParameters() {
        return this.parameters;
    }

    public boolean isEnum() {
        return this.clazzRaw.isEnum();
    }

    public Class<?> getClazzRaw() {
        return this.clazzRaw;
    }

    public String getName() {
        return this.name;
    }
}

