/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info;

import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import com.probejs.util.Util;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldInfo {
    private final String name;
    private final int modifiers;
    private final boolean shouldHide;
    private final Object value;
    private ITypeInfo info;

    private static String getRemappedOrDefault(Field field) {
        String s = MethodInfo.RUNTIME.getMappedField(field.getDeclaringClass(), field);
        return s.isEmpty() ? field.getName() : s;
    }

    public FieldInfo(Field field) {
        this.name = FieldInfo.getRemappedOrDefault(field);
        this.modifiers = field.getModifiers();
        this.shouldHide = field.getAnnotation(HideFromJS.class) != null;
        this.info = InfoTypeResolver.resolveType(field.getGenericType());
        this.value = Util.tryOrDefault(() -> this.isStatic() ? field.get(null) : null, null);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldHide() {
        return this.shouldHide;
    }

    public ITypeInfo getType() {
        return this.info;
    }

    public Object getStaticValue() {
        return this.value;
    }

    public void setTypeInfo(ITypeInfo info) {
        this.info = info;
    }
}

