/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info;

import com.probejs.info.ClassInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import com.probejs.info.type.TypeInfoClass;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.Remapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MethodInfo {
    private final String name;
    private final boolean shouldHide;
    private final int modifiers;
    private final Class<?> from;
    private ITypeInfo returnType;
    private List<ParamInfo> params;
    private List<ITypeInfo> typeVariables;
    public static final Remapper RUNTIME = RemappingHelper.createModRemapper();

    private static String getRemappedOrDefault(Method method, Class<?> from) {
        String s = method.getName();
        while (from != null && from != Object.class && (s = RUNTIME.getMappedMethod(from, method)).equals(method.getName())) {
            Class<?> implemented;
            Class<?>[] classArray = from.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (s = RUNTIME.getMappedMethod(implemented = classArray[i], method)).equals(method.getName()); ++i) {
            }
            from = from.getSuperclass();
        }
        return s;
    }

    public MethodInfo(Method method, Class<?> from) {
        this.name = MethodInfo.getRemappedOrDefault(method, from);
        this.shouldHide = method.getAnnotation(HideFromJS.class) != null;
        this.from = from;
        this.modifiers = method.getModifiers();
        this.returnType = InfoTypeResolver.resolveType(method.getGenericReturnType());
        this.params = Arrays.stream(method.getParameters()).map(ParamInfo::new).collect(Collectors.toList());
        this.typeVariables = Arrays.stream(method.getTypeParameters()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldHide() {
        return this.shouldHide;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers) && !this.from.isInterface();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public ITypeInfo getReturnType() {
        return this.returnType;
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public List<ITypeInfo> getTypeVariables() {
        return this.typeVariables;
    }

    public ClassInfo getFrom() {
        return ClassInfo.getOrCache(this.from);
    }

    public void setParams(List<ParamInfo> params) {
        this.params = params;
    }

    public void setReturnType(ITypeInfo returnType) {
        this.returnType = returnType;
    }

    public void setTypeVariables(List<ITypeInfo> typeVariables) {
        this.typeVariables = typeVariables;
    }

    public static class ParamInfo {
        private final String name;
        private boolean isVararg;
        private ITypeInfo type;

        public ParamInfo(Parameter parameter) {
            this.name = parameter.getName();
            this.isVararg = parameter.isVarArgs();
            try {
                this.type = InfoTypeResolver.resolveType(parameter.getParameterizedType());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.type = new TypeInfoClass((Type)((Object)Object.class));
            }
        }

        public String getName() {
            return this.name;
        }

        public ITypeInfo getType() {
            return this.type;
        }

        public boolean isVararg() {
            return this.isVararg;
        }

        public void setTypeInfo(ITypeInfo type) {
            this.type = type;
        }
    }
}

