/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info.type;

import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.TypeInfoArray;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.info.type.TypeInfoParameterized;
import com.probejs.info.type.TypeInfoVariable;
import com.probejs.info.type.TypeInfoWildcard;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class InfoTypeResolver {
    public static ITypeInfo resolveType(Type type) {
        if (TypeInfoArray.test(type)) {
            return new TypeInfoArray(type);
        }
        if (TypeInfoClass.test(type)) {
            return new TypeInfoClass(type);
        }
        if (TypeInfoVariable.test(type)) {
            return new TypeInfoVariable(type);
        }
        if (TypeInfoWildcard.test(type)) {
            return new TypeInfoWildcard(type);
        }
        if (TypeInfoParameterized.test(type)) {
            return new TypeInfoParameterized(type);
        }
        return null;
    }

    public static ITypeInfo getContainedTypeOrSelf(ITypeInfo typeInfo) {
        if (typeInfo instanceof TypeInfoParameterized) {
            TypeInfoParameterized paramType = (TypeInfoParameterized)typeInfo;
            ITypeInfo baseType = paramType.getBaseType();
            if (baseType.assignableFrom(InfoTypeResolver.resolveType(Collection.class)) && paramType.getParamTypes().size() > 0) {
                return paramType.getParamTypes().get(0);
            }
            if (baseType.assignableFrom(InfoTypeResolver.resolveType(Map.class)) && paramType.getParamTypes().size() > 1) {
                return paramType.getParamTypes().get(1);
            }
        }
        return typeInfo;
    }

    public static ITypeInfo mutateTypeMap(ITypeInfo typeInfo, Map<String, ITypeInfo> toMutate) {
        if (typeInfo instanceof TypeInfoClass || typeInfo instanceof TypeInfoVariable) {
            return toMutate.getOrDefault(typeInfo.getTypeName(), typeInfo).copy();
        }
        if ((typeInfo = typeInfo.copy()) instanceof TypeInfoWildcard) {
            TypeInfoWildcard wild = (TypeInfoWildcard)typeInfo;
            return InfoTypeResolver.mutateTypeMap(wild.getBaseType(), toMutate);
        }
        if (typeInfo instanceof TypeInfoArray) {
            TypeInfoArray array = (TypeInfoArray)typeInfo;
            array.setType(InfoTypeResolver.mutateTypeMap(array.getBaseType(), toMutate));
        }
        if (typeInfo instanceof TypeInfoParameterized) {
            TypeInfoParameterized parType = (TypeInfoParameterized)typeInfo;
            parType.setRawType(InfoTypeResolver.mutateTypeMap(parType.getBaseType(), toMutate));
            parType.setParamTypes(parType.getParamTypes().stream().map(info -> InfoTypeResolver.mutateTypeMap(info, toMutate)).collect(Collectors.toList()));
        }
        return typeInfo;
    }
}

