/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info.type;

import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.List;

public class TypeInfoArray
implements ITypeInfo {
    private ITypeInfo type;

    public static boolean test1(Type type) {
        return type instanceof GenericArrayType;
    }

    public static boolean test2(Type type) {
        Class clazz;
        return type instanceof Class && (clazz = (Class)type).isArray();
    }

    public static boolean test(Type type) {
        return TypeInfoArray.test1(type) || TypeInfoArray.test2(type);
    }

    public TypeInfoArray(Type type) {
        if (TypeInfoArray.test1(type)) {
            this.type = InfoTypeResolver.resolveType(((GenericArrayType)type).getGenericComponentType());
        }
        if (TypeInfoArray.test2(type)) {
            assert (type instanceof Class);
            this.type = InfoTypeResolver.resolveType(((Class)type).getComponentType());
        }
    }

    private TypeInfoArray(ITypeInfo inner) {
        this.type = inner;
    }

    @Override
    public ITypeInfo getBaseType() {
        return this.type;
    }

    @Override
    public Class<?> getResolvedClass() {
        return List.class;
    }

    @Override
    public String getTypeName() {
        return this.type.getTypeName() + "[]";
    }

    public void setType(ITypeInfo type) {
        this.type = type;
    }

    @Override
    public ITypeInfo copy() {
        return new TypeInfoArray(this.type.copy());
    }

    @Override
    public boolean assignableFrom(ITypeInfo info) {
        return info instanceof TypeInfoArray && info.getBaseType().assignableFrom(this.type);
    }
}

