/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.util;

import com.probejs.document.parser.handler.AbstractStackedMachine;
import com.probejs.document.parser.handler.IStateHandler;
import com.probejs.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StringUtil {
    public static int indexLayer(String s, String push, String pop, String delimiter) {
        List ss = s.chars().mapToObj(Character::toString).collect(Collectors.toList());
        SplitState state = new SplitState(push, pop, delimiter);
        for (String step : ss) {
            state.step(step);
            if (!state.isEmpty()) continue;
            break;
        }
        return state.getIndex();
    }

    public static Pair<String, String> splitFirst(String s, String push, String pop, String delimiter) {
        int index = StringUtil.indexLayer(s, push, pop, delimiter);
        if (index == -1) {
            return null;
        }
        return new Pair<String, String>(s.substring(0, index - 1), s.substring(index));
    }

    public static List<String> splitLayer(String s, String push, String pop, String delimiter) {
        ArrayList<String> splits = new ArrayList<String>();
        Pair<String, String> splitResult = StringUtil.splitFirst(s, push, pop, delimiter);
        while (splitResult != null) {
            splits.add(splitResult.getFirst());
            s = splitResult.getSecond();
            splitResult = StringUtil.splitFirst(s, push, pop, delimiter);
        }
        splits.add(s);
        return splits;
    }

    private static class SplitState
    extends AbstractStackedMachine<String> {
        private int index = 0;

        private SplitState(String push, String pop, String delimiter) {
            this.stack.add(new Split(push, pop, delimiter));
        }

        @Override
        public void step(String element) {
            super.step(element);
            ++this.index;
        }

        private int getIndex() {
            if (this.stack.isEmpty()) {
                return this.index;
            }
            return -1;
        }
    }

    private static class Split
    implements IStateHandler<String> {
        private final String push;
        private final String pop;
        private final String split;

        private Split(String push, String pop, String split) {
            this.push = push;
            this.pop = pop;
            this.split = split;
        }

        @Override
        public void trial(String element, List<IStateHandler<String>> stack) {
            if (this.push.contains(element)) {
                stack.add(new Mask(this.push, this.pop));
            }
            if (element.equals(this.split)) {
                stack.remove(this);
            }
        }
    }

    private static class Mask
    implements IStateHandler<String> {
        private final String push;
        private final String pop;

        private Mask(String push, String pop) {
            this.push = push;
            this.pop = pop;
        }

        @Override
        public void trial(String element, List<IStateHandler<String>> stack) {
            if (this.push.contains(element)) {
                stack.add(new Mask(this.push, this.pop));
            }
            if (this.pop.contains(element)) {
                stack.remove(this);
            }
        }
    }
}

