/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.util.forge;

import com.google.common.collect.BiMap;
import com.probejs.formatter.SpecialTypes;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.util.PlatformSpecial;
import dev.architectury.platform.Platform;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class PlatformSpecialImpl
extends PlatformSpecial {
    private static Field ingredientInst = null;
    private boolean inited = false;

    @Override
    @NotNull
    public List<ResourceLocation> getIngredientTypes() {
        if (ingredientInst == null) {
            Field ingredients;
            try {
                ingredients = CraftingHelper.class.getDeclaredField("ingredients");
                ingredients.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                return List.of();
            }
            ingredientInst = ingredients;
        }
        try {
            BiMap ingredientValue = (BiMap)ingredientInst.get(null);
            return ingredientValue.keySet().stream().toList();
        }
        catch (IllegalAccessException e) {
            return List.of();
        }
    }

    @Override
    @NotNull
    public List<IFormatter> getPlatformFormatters() {
        ArrayList<IFormatter> formatters = new ArrayList<IFormatter>();
        if (!this.inited) {
            if (Platform.isModLoaded((String)"kubejs_mekanism")) {
                SpecialTypes.assignRegistry(Gas.class, MekanismAPI.gasRegistry().getRegistryKey());
                SpecialTypes.assignRegistry(Slurry.class, MekanismAPI.slurryRegistry().getRegistryKey());
                SpecialTypes.assignRegistry(InfuseType.class, MekanismAPI.infuseTypeRegistry().getRegistryKey());
                SpecialTypes.assignRegistry(Pigment.class, MekanismAPI.pigmentRegistry().getRegistryKey());
            }
            this.inited = true;
        }
        return formatters;
    }
}

