// priority: 0

const STRIPPED_LOGS = [
  'tfc:wood/stripped_log/acacia',
  'tfc:wood/stripped_log/ash',
  'tfc:wood/stripped_log/aspen',
  'tfc:wood/stripped_log/birch',
  'tfc:wood/stripped_log/blackwood',
  'tfc:wood/stripped_log/chestnut',
  'tfc:wood/stripped_log/douglas_fir',
  'tfc:wood/stripped_log/hickory',
  'tfc:wood/stripped_log/kapok',
  'tfc:wood/stripped_log/maple',
  'tfc:wood/stripped_log/oak',
  'tfc:wood/stripped_log/palm',
  'tfc:wood/stripped_log/pine',
  'tfc:wood/stripped_log/rosewood',
  'tfc:wood/stripped_log/sequoia',
  'tfc:wood/stripped_log/spruce',
  'tfc:wood/stripped_log/sycamore',
  'tfc:wood/stripped_log/white_cedar',
  'tfc:wood/stripped_log/willow',
  'tfc:wood/stripped_wood/acacia',
  'tfc:wood/stripped_wood/ash',
  'tfc:wood/stripped_wood/aspen',
  'tfc:wood/stripped_wood/birch',
  'tfc:wood/stripped_wood/blackwood',
  'tfc:wood/stripped_wood/chestnut',
  'tfc:wood/stripped_wood/douglas_fir',
  'tfc:wood/stripped_wood/hickory',
  'tfc:wood/stripped_wood/kapok',
  'tfc:wood/stripped_wood/maple',
  'tfc:wood/stripped_wood/oak',
  'tfc:wood/stripped_wood/palm',
  'tfc:wood/stripped_wood/pine',
  'tfc:wood/stripped_wood/rosewood',
  'tfc:wood/stripped_wood/sequoia',
  'tfc:wood/stripped_wood/spruce',
  'tfc:wood/stripped_wood/sycamore',
  'tfc:wood/stripped_wood/white_cedar',
  'tfc:wood/stripped_wood/willow',
];

const FLUIDS = {
  ZINC: { name: 'tfc:metal/zinc', temp: 420 },
  IRON: { name: 'tfc:metal/cast_iron', temp: 1535 },
  GOLD: { name: 'tfc:metal/gold', temp: 1060 },
  COPPER: { name: 'tfc:metal/copper', temp: 1080 },
  BRASS: { name: 'tfc:metal/brass', temp: 930 },
};

onEvent('recipes', event => {
  const removeRecipes = () => {
    [
      '#create:crushed_ores',
      'create:brass_block',
      'create:brass_nugget',
      'create:brass_sheet',
      'create:copper_nugget',
      'create:copper_sheet',
      'create:deepslate_zinc_ore',
      'create:golden_sheet',
      'create:iron_sheet',
      'create:raw_zinc_block',
      'create:raw_zinc',
      'create:schematic_table',
      'create:schematicannon',
      'create:zinc_block',
      'create:zinc_nugget',
      'create:zinc_ore',
      'minecraft:gold_nugget',
      'minecraft:iron_nugget',
      'minecraft:copper_ingot',
      'create:brass_ingot',
      'create:zinc_ingot',
    ].forEach(x => {
      event.remove({ type: 'minecraft:crafting_shaped', output: x });
      event.remove({ type: 'minecraft:crafting_shapeless', output: x });
    });

    [
      '#create:crushed_ores',
      'create:brass_block',
      'create:raw_zinc_block',
      'create:raw_zinc',
      'create:deepslate_zinc_ore',
      'create:schematic_table',
      'create:schematicannon',
      'create:zinc_block',
      'create:zinc_ore',
    ].forEach(x => {
      event.remove({ type: 'minecraft:crafting_shaped', input: x });
      event.remove({ type: 'minecraft:crafting_shapeless', input: x });
    });

    event.remove({ mod: 'minecraft', input: 'minecraft:copper_ingot' });
    event.remove({ mod: 'minecraft', input: 'minecraft:iron_ingot' });
    event.remove({ mod: 'minecraft', input: 'minecraft:gold_ingot' });
    event.remove({ mod: 'minecraft', input: 'minecraft:iron_nugget' });
    event.remove({ mod: 'minecraft', input: 'minecraft:gold_nugget' });

    event.remove({ mod: 'minecraft', output: 'minecraft:copper_ingot' });
    event.remove({ mod: 'minecraft', output: 'minecraft:iron_ingot' });
    event.remove({ mod: 'minecraft', output: 'minecraft:gold_ingot' });
    event.remove({ mod: 'minecraft', output: 'minecraft:iron_nugget' });
    event.remove({ mod: 'minecraft', output: 'minecraft:gold_nugget' });

    // Prevents 9x glue -> slime block
    event.remove({ mod: 'minecraft', output: 'minecraft:slime_block' });
  };

  const unifyInputs = () => {
    // Unify Vanilla-ish mats with TFC's
    event.replaceInput({}, 'minecraft:chest', '#forge:chests/wooden');
    event.replaceInput({}, 'minecraft:barrel', '#tfc:barrels');
    event.replaceInput({}, 'minecraft:dried_kelp', 'tfc:food/dried_kelp');
    event.replaceInput({}, 'minecraft:sand', '#forge:sand');
    event.replaceInput({}, 'minecraft:slime_ball', 'tfc:glue');

    // Use nuggets in place of ingots
    event.replaceInput({ mod: 'create' }, 'minecraft:copper_ingot', '#forge:nuggets/copper');
    event.replaceInput({ mod: 'create' }, 'minecraft:iron_ingot', '#forge:nuggets/iron');
    event.replaceInput({ mod: 'create' }, 'minecraft:gold_ingot', '#forge:nuggets/gold');
    event.replaceInput({ mod: 'create' }, 'create:brass_ingot', '#forge:nuggets/brass');
    event.replaceInput({ mod: 'create' }, 'create:zinc_ingot', '#forge:nuggets/zinc');

    // For blocks of a material, use the whole ingot
    event.replaceInput({ mod: 'create' }, 'minecraft:copper_block', 'tfc:metal/double_ingot/copper');
    event.replaceInput({ mod: 'create' }, 'minecraft:iron_block', 'tfc:metal/double_ingot/wrought_iron');
    event.replaceInput({ mod: 'create' }, 'minecraft:gold_block', 'tfc:metal/double_ingot/gold');
    event.replaceInput({ mod: 'create' }, 'create:brass_block', 'tfc:metal/double_ingot/brass');
    event.replaceInput({ mod: 'create' }, 'create:zinc_block', 'tfc:metal/double_ingot/zinc');
  };

  const melting = () => {
    [
      // Nuggets
      { item: 'minecraft:iron_nugget', temp: FLUIDS.IRON.temp, fluid: { name: FLUIDS.IRON.name, amount: 10 } },
      { item: 'minecraft:gold_nugget', temp: FLUIDS.GOLD.temp, fluid: { name: FLUIDS.GOLD.name, amount: 10 } },
      { item: 'create:copper_nugget', temp: FLUIDS.COPPER.temp, fluid: { name: FLUIDS.COPPER.name, amount: 10 } },
      { item: 'create:brass_nugget', temp: FLUIDS.BRASS.temp, fluid: { name: FLUIDS.BRASS.name, amount: 10 } },
      { item: 'create:zinc_nugget', temp: FLUIDS.ZINC.temp, fluid: { name: FLUIDS.ZINC.name, amount: 10 } },
      // Sheets
      { item: 'create:iron_sheet', temp: FLUIDS.IRON.temp, fluid: { name: FLUIDS.IRON.name, amount: 25 } },
      { item: 'create:golden_sheet', temp: FLUIDS.GOLD.temp, fluid: { name: FLUIDS.GOLD.name, amount: 25 } },
      { item: 'create:copper_sheet', temp: FLUIDS.COPPER.temp, fluid: { name: FLUIDS.COPPER.name, amount: 25 } },
      { item: 'create:brass_sheet', temp: FLUIDS.BRASS.temp, fluid: { name: FLUIDS.BRASS.name, amount: 25 } },
    ].forEach(recipe => {
      event.custom({
        type: "tfc:heating",
        ingredient: { "item": recipe.item },
        result_fluid: { fluid: recipe.fluid.name, amount: recipe.fluid.amount },
        temperature: recipe.temp
      });
    });
  };

  const hammerIngotToNuggets = () => {
    [
      { ingot: "tfc:metal/ingot/wrought_iron", nugget: "minecraft:iron_nugget" },
      { ingot: "tfc:metal/ingot/gold", nugget: "minecraft:gold_nugget" },
      { ingot: "tfc:metal/ingot/copper", nugget: "create:copper_nugget" },
      { ingot: "tfc:metal/ingot/brass", nugget: "create:brass_nugget" },
      { ingot: "tfc:metal/ingot/zinc", nugget: "create:zinc_nugget" },
    ].forEach(pair => {
      event.custom({
        type: "tfc:damage_inputs_shapeless_crafting",
        recipe: {
          type: "minecraft:crafting_shapeless",
          ingredients: [{ item: pair.ingot }, { tag: "tfc:hammers" }],
          result: { item: pair.nugget, count: 10 }
        }
      });
    });
  };

  const cutSheetToSmallSheet = () => {
    // Iron
    event.custom({
      type: "tfc:damage_inputs_shapeless_crafting",
      recipe: {
        type: "minecraft:crafting_shapeless",
        ingredients: [{ item: 'tfc:metal/sheet/wrought_iron' }, { tag: "tfc:shears" }],
        result: { item: 'create:iron_sheet', count: 8 }
      }
    });
    // Gold
    event.custom({
      type: "tfc:damage_inputs_shapeless_crafting",
      recipe: {
        type: "minecraft:crafting_shapeless",
        ingredients: [{ item: 'tfc:metal/sheet/gold' }, { tag: "tfc:shears" }],
        result: { item: 'create:golden_sheet', count: 8 }
      }
    });
    // Copper
    event.custom({
      type: "tfc:damage_inputs_shapeless_crafting",
      recipe: {
        type: "minecraft:crafting_shapeless",
        ingredients: [{ item: 'tfc:metal/sheet/copper' }, { tag: "tfc:shears" }],
        result: { item: 'create:copper_sheet', count: 8 }
      }
    });
    // Brass
    event.custom({
      type: "tfc:damage_inputs_shapeless_crafting",
      recipe: {
        type: "minecraft:crafting_shapeless",
        ingredients: [{ item: 'tfc:metal/sheet/brass' }, { tag: "tfc:shears" }],
        result: { item: 'create:brass_sheet', count: 8 }
      }
    });
  };

  const rebalanceAndesiteAlloy = () => {
    event.remove({ type: 'minecraft:crafting_shaped', output: 'create:andesite_alloy' });
    event.remove({ type: 'minecraft:crafting_shapeless', output: 'create:andesite_alloy' });
    event.remove({ type: 'create:mixing', output: 'create:andesite_alloy' });

    event.recipes.create.mixing(
      Item.of('4x create:andesite_alloy'), [
      Item.of('tfc:rock/loose/andesite'),
      Fluid.of('tfc:metal/zinc', 10)
    ]);

    event.custom({
      "type": "tfc:bloomery",
      "result": {
        "item": "create:andesite_alloy",
        "count": 2
      },
      "fluid": {
        "ingredient": "tfc:metal/zinc",
        "amount": 10
      },
      "catalyst": {
        "item": "tfc:rock/loose/andesite"
      },
      "duration": 10000
    });
  };

  const integrateQuartzSomehow = () => {
    event.custom({
      type: "tfc:quern",
      ingredient: { item: "tfc:rock/loose/diorite" },
      result: { item: "minecraft:quartz" }
    });
    event.replaceInput({ type: 'create:crushing' }, 'minecraft:diorite', 'tfc:rock/loose/diorite');

    event.remove({ output: "create:rose_quartz" });
    event.recipes.create.mixing(
      Item.of('1x create:rose_quartz'), [
      Item.of('3x minecraft:redstone'),
      Item.of('2x minecraft:quartz'),
    ]);
  };

  const seqAssembly = () => {
    event.remove({ output: 'create:track' });
    event.custom({
      "type": "create:sequenced_assembly",
      "ingredient": { "tag": "minecraft:logs" },
      "transitionalItem": { "item": "create:incomplete_track" },
      "sequence": [{
        "type": "create:deploying",
        "ingredients": [
          { "item": "create:incomplete_track" },
          [{ "item": "tfc:metal/rod/zinc" }]
        ],
        "results": [{ "item": "create:incomplete_track" }]
      }, {
        "type": "create:deploying",
        "ingredients": [
          { "item": "create:incomplete_track" },
          [{ "item": "tfc:metal/rod/zinc" }]
        ],
        "results": [{ "item": "create:incomplete_track" }]
      }, {
        "type": "create:pressing",
        "ingredients": [{ "item": "create:incomplete_track" }],
        "results": [{ "item": "create:incomplete_track" }]
      }],
      "results": [{ "item": "create:track" }],
      "loops": 1
    });
  };

  removeRecipes();
  unifyInputs();
  melting();
  hammerIngotToNuggets();
  cutSheetToSmallSheet();
  rebalanceAndesiteAlloy();
  integrateQuartzSomehow();
  seqAssembly();
});


onEvent('block.tags', event => {
  event.add('forge:stripped_logs', STRIPPED_LOGS);
});

onEvent('item.tags', event => {
  event.add('forge:stripped_logs', STRIPPED_LOGS);
});