/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.abyssalcraft.mixin;

import com.shinoow.abyssalcraft.api.transfer.ItemTransferConfiguration;
import com.shinoow.abyssalcraft.api.transfer.caps.IItemTransferCapability;
import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapability;
import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapabilityProvider;
import com.shinoow.abyssalcraft.common.entity.EntitySpiritItem;
import com.shinoow.abyssalcraft.common.handlers.ItemTransferEventHandler;
import java.util.Map;
import mod.acgaming.universaltweaks.config.UTConfig;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.UTWorldDataCapability;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.UTWorldDataCapabilityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemTransferEventHandler.class}, remap=false)
public class UTItemTransferEventHandlerMixin {
    private static final String CHECK_ID = "universaltweaksAbyssalConfigurations";

    @SubscribeEvent
    public void attachCapabilityWorld(AttachCapabilitiesEvent<World> event) {
        if (!UTConfig.MOD_INTEGRATION.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        event.addCapability(new ResourceLocation("universaltweaks", "WorldDataCapability"), (ICapabilityProvider)new UTWorldDataCapabilityProvider());
    }

    @SubscribeEvent
    public void utOnChunkSave(ChunkDataEvent.Save event) {
        if (!UTConfig.MOD_INTEGRATION.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        Chunk chunk = event.getChunk();
        Map<BlockPos, TileEntity> set = UTWorldDataCapability.getCap(event.getWorld()).getChunkMap(chunk);
        if (set != null && !set.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            for (BlockPos pos : set.keySet()) {
                TileEntity te = event.getWorld().func_175625_s(pos);
                if (te != null && !te.hasCapability(ItemTransferCapabilityProvider.ITEM_TRANSFER_CAP, null)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", pos.func_177958_n());
                tag.func_74768_a("y", pos.func_177956_o());
                tag.func_74768_a("z", pos.func_177952_p());
                tagList.func_74742_a((NBTBase)tag);
            }
            if (!event.getChunk().func_177410_o() || tagList.func_82582_d()) {
                UTWorldDataCapability.getCap(event.getWorld()).removeChunk(event.getChunk());
                if (tagList.func_82582_d()) {
                    return;
                }
            }
            event.getData().func_74782_a(CHECK_ID, (NBTBase)tagList);
        }
    }

    @SubscribeEvent
    public void utOnChunkLoad(ChunkDataEvent.Load event) {
        if (!UTConfig.MOD_INTEGRATION.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getData().func_74764_b(CHECK_ID)) {
            World world = event.getWorld();
            NBTTagList tagList = event.getData().func_150295_c(CHECK_ID, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                TileEntity te = world.func_175667_e(pos) ? world.func_175625_s(pos) : null;
                UTWorldDataCapability.getCap(world).addConfigured(event.getChunk(), pos, te);
            }
        }
    }

    @Inject(method={"onTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void utOnTick(TickEvent.WorldTickEvent event, CallbackInfo ci) {
        if (!UTConfig.MOD_INTEGRATION.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        ci.cancel();
        if (event.side == Side.SERVER && event.type == TickEvent.Type.WORLD && event.phase == TickEvent.Phase.END) {
            World world = event.world;
            if (world.func_82737_E() % 20L != 0L) {
                return;
            }
            if (UTWorldDataCapability.getCap(world).isEmpty()) {
                return;
            }
            UTWorldDataCapability.getCap(world).getFlattenedView().forEach((pos, tile) -> {
                if (!world.func_175667_e(pos)) {
                    return;
                }
                if (tile == null) {
                    tile = world.func_175625_s(pos);
                    UTWorldDataCapability.getCap(world).updateConfigured(world.func_175726_f(pos), (BlockPos)pos, (TileEntity)tile);
                }
                if (!this.hasCap((TileEntity)tile)) {
                    return;
                }
                IItemTransferCapability cap = ItemTransferCapability.getCap((TileEntity)tile);
                for (ItemTransferConfiguration cfg : cap.getTransferConfigurations()) {
                    IItemHandler exitInv;
                    BlockPos exitPos;
                    TileEntity te;
                    IItemHandler inventory = ItemTransferEventHandler.getInventory((TileEntity)tile, (EnumFacing)cfg.getExitFacing());
                    if (inventory == null) continue;
                    boolean hasFilter = !cfg.getFilter().isEmpty() && cfg.getFilter().stream().anyMatch(i -> !i.func_190926_b());
                    ItemStack stack = ItemStack.field_190927_a;
                    int slot = -1;
                    for (int i2 = 0; i2 < inventory.getSlots(); ++i2) {
                        stack = inventory.getStackInSlot(i2);
                        if (stack.func_190926_b() || hasFilter && !this.isInFilter((NonNullList<ItemStack>)cfg.getFilter(), stack, cfg.filterByNBT())) continue;
                        stack = inventory.extractItem(i2, 1, true);
                        slot = i2;
                        break;
                    }
                    if (stack.func_190926_b() || slot <= -1 || (te = world.func_175625_s(exitPos = cfg.getRoute()[cfg.getRoute().length - 1])) == null || (exitInv = ItemTransferEventHandler.getInventory((TileEntity)te, (EnumFacing)cfg.getEntryFacing())) == null || !ItemHandlerHelper.insertItem((IItemHandler)exitInv, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                    stack = inventory.extractItem(slot, 1, false);
                    EntitySpiritItem spirit = new EntitySpiritItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
                    spirit.setRoute(cfg.getRoute());
                    spirit.setFacing(cfg.getEntryFacing());
                    world.func_72838_d((Entity)spirit);
                }
            });
        }
    }

    @Shadow
    private boolean hasCap(TileEntity te) {
        return false;
    }

    @Shadow
    private boolean isInFilter(NonNullList<ItemStack> filter, ItemStack stack, boolean nbt) {
        return false;
    }
}

