/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.endportal.renderer;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CustomEndPortalRenderer {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private final FloatBuffer texBuffer = GLAllocation.func_74529_h((int)16);

    public void render(TileEntityEndPortal portalEntity, float offsetTop, float offsetBot, double posX, double posY, double posZ, double playerX, double playerY, double playerZ, TextureManager r) {
        if (r == null) {
            return;
        }
        GlStateManager.func_179140_f();
        RANDOM.setSeed(31100L);
        for (int i = 0; i < 16; ++i) {
            GlStateManager.func_179094_E();
            float portalSurfaceY = (float)(posY + (double)offsetTop);
            float layerDepth = 16 - i;
            float layerScale = 0.0625f;
            float layerColorStrength = 1.0f / (layerDepth + 1.0f);
            if (i == 0) {
                r.func_110577_a(END_SKY_TEXTURE);
                layerColorStrength = 0.1f;
                layerDepth = 65.0f;
                layerScale = 0.125f;
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (i == 1) {
                r.func_110577_a(END_PORTAL_TEXTURE);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                layerScale = 0.5f;
            }
            float f8 = -portalSurfaceY;
            float f9 = (float)((double)f8 + ActiveRenderInfo.getCameraPosition().field_72448_b);
            float f10 = (float)((double)(f8 + layerDepth) + ActiveRenderInfo.getCameraPosition().field_72448_b);
            float f11 = f9 / f10 + portalSurfaceY;
            GlStateManager.func_179137_b((double)playerX, (double)f11, (double)playerZ);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9217);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9217);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9217);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9216);
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9473, (FloatBuffer)this.bufferTexData(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9473, (FloatBuffer)this.bufferTexData(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9473, (FloatBuffer)this.bufferTexData(0.0f, 0.0f, 0.0f, 1.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9474, (FloatBuffer)this.bufferTexData(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.Q);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 700000.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)layerScale, (float)layerScale, (float)layerScale);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-playerX), (double)(-playerZ), (double)(-playerY));
            f9 = f8 + (float)ActiveRenderInfo.getCameraPosition().field_72448_b;
            GlStateManager.func_179137_b((double)((float)ActiveRenderInfo.getCameraPosition().field_72450_a * layerDepth / f9), (double)((float)ActiveRenderInfo.getCameraPosition().field_72449_c * layerDepth / f9), (double)(-playerY + 20.0));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float red = (RANDOM.nextFloat() * 0.5f + 0.1f) * layerColorStrength;
            float green = (RANDOM.nextFloat() * 0.5f + 0.4f) * layerColorStrength;
            float blue = (RANDOM.nextFloat() * 0.5f + 0.5f) * layerColorStrength;
            if (i == 0) {
                green = blue = layerColorStrength;
                red = blue;
            }
            if (portalEntity.func_184313_a(EnumFacing.SOUTH)) {
                buffer.func_181662_b(posX, posY + (double)offsetBot, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetBot, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetTop, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX, posY + (double)offsetTop, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (portalEntity.func_184313_a(EnumFacing.NORTH)) {
                buffer.func_181662_b(posX, posY + (double)offsetTop, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetTop, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetBot, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX, posY + (double)offsetBot, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (portalEntity.func_184313_a(EnumFacing.EAST)) {
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetTop, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetTop, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetBot, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetBot, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (portalEntity.func_184313_a(EnumFacing.WEST)) {
                buffer.func_181662_b(posX, posY + (double)offsetBot, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX, posY + (double)offsetBot, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX, posY + (double)offsetTop, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX, posY + (double)offsetTop, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (portalEntity.func_184313_a(EnumFacing.DOWN)) {
                buffer.func_181662_b(posX, posY + (double)offsetBot, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetBot, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetBot, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX, posY + (double)offsetBot, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (portalEntity.func_184313_a(EnumFacing.UP)) {
                buffer.func_181662_b(posX, posY + (double)offsetTop, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetTop, posZ + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX + 1.0, posY + (double)offsetTop, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                buffer.func_181662_b(posX, posY + (double)offsetTop, posZ).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.Q);
        GlStateManager.func_179145_e();
    }

    private FloatBuffer bufferTexData(float f, float f1, float f2, float f3) {
        this.texBuffer.clear();
        this.texBuffer.put(f).put(f1).put(f2).put(f3);
        this.texBuffer.flip();
        return this.texBuffer;
    }
}

