/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.world.chunks.tidy.mixin;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import mod.acgaming.universaltweaks.tweaks.world.chunks.tidy.UTWorldContext;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="universaltweaks")
public class UTTidyChunk {
    public static Int2ObjectArrayMap<UTWorldContext> worldData = new Int2ObjectArrayMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utOnWorldUnload(WorldEvent.Unload event) {
        if (!UTConfig.TWEAKS_WORLD.utTidyChunkToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTTidyChunk ::: World unload event");
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        UTTidyChunk.getWorldContext(world).searchAndDestroy(world);
        worldData.remove(world.field_73011_w.getDimension());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utOnWorldTick(TickEvent.WorldTickEvent event) {
        if (!UTConfig.TWEAKS_WORLD.utTidyChunkToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTTidyChunk ::: World tick event");
        }
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        UTWorldContext ctx = UTTidyChunk.getWorldContext(event.world);
        ctx.searchAndDestroy(event.world);
        ctx.removeOldContext(event.world);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utOnChunkPopulate(PopulateChunkEvent.Pre event) {
        if (!UTConfig.TWEAKS_WORLD.utTidyChunkToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTTidyChunk ::: Populate chunk event");
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        UTWorldContext ctx = UTTidyChunk.getWorldContext(event.getWorld());
        ctx.add(new ChunkPos(event.getChunkX(), event.getChunkZ()), event.getWorld());
    }

    @SubscribeEvent
    public static void utOnEntityJoin(EntityJoinWorldEvent event) {
        if (!UTConfig.TWEAKS_WORLD.utTidyChunkToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTTidyChunk ::: Entity join event");
        }
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (world.field_72995_K || !UTWorldContext.isTargetEntity(entity)) {
            return;
        }
        UTWorldContext ctx = UTTidyChunk.getWorldContext(world);
        if (ctx.isContained(entity)) {
            ctx.removeEntity(entity);
            event.setCanceled(true);
        }
    }

    public static UTWorldContext createWorldContext(World world) {
        UTWorldContext ctx = new UTWorldContext();
        worldData.put(world.field_73011_w.getDimension(), (Object)ctx);
        return ctx;
    }

    public static UTWorldContext getWorldContext(World world) {
        UTWorldContext ctx = (UTWorldContext)worldData.get(world.field_73011_w.getDimension());
        return ctx == null ? UTTidyChunk.createWorldContext(world) : ctx;
    }
}

