/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.enchantment;

import com.oitsjustjose.vtweaks.enchantment.EnchantmentImperishable;
import com.oitsjustjose.vtweaks.enchantment.EnchantmentLumbering;
import com.oitsjustjose.vtweaks.enchantment.FeatherFallingTweak;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentImperishableHandler;
import com.oitsjustjose.vtweaks.enchantment.handler.EnchantmentLumberingHandler;
import com.oitsjustjose.vtweaks.util.ModConfig;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Enchantments {
    private static Enchantments instance;
    public Enchantment lumbering;
    public Enchantment imperishable;
    private ArrayList<Enchantment> toRegister = new ArrayList();

    private Enchantments() {
        this.init();
    }

    public static Enchantments getInstance() {
        if (instance == null) {
            instance = new Enchantments();
        }
        return instance;
    }

    private void init() {
        if (ModConfig.enchantments.enableLumbering) {
            this.lumbering = new EnchantmentLumbering();
            this.registerEnchantment(this.lumbering);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentLumberingHandler());
        }
        if (ModConfig.enchantments.enableImperishable) {
            this.imperishable = new EnchantmentImperishable();
            this.registerEnchantment(this.imperishable);
            MinecraftForge.EVENT_BUS.register((Object)new EnchantmentImperishableHandler());
        }
        if (ModConfig.enchantments.enableFeatherFallTweak) {
            MinecraftForge.EVENT_BUS.register((Object)new FeatherFallingTweak());
        }
    }

    public void registerEnchantment(Enchantment ench) {
        this.toRegister.add(ench);
    }

    @SubscribeEvent
    public void handleRegistry(RegistryEvent.Register<Enchantment> event) {
        for (Enchantment e : this.toRegister) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
    }
}

