/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.enchantment.handler;

import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.ModConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentLumberingHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void register(BlockEvent.BreakEvent event) {
        if (!ModConfig.enchantments.enableLumbering) {
            return;
        }
        if (event.getState() == null || event.getWorld() == null || event.getPlayer() == null || event.getPlayer().func_184614_ca().func_190926_b() || event.getPlayer().field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().lumbering, (ItemStack)player.func_184614_ca()) > 0 && player.func_70093_af() && event.getState().func_177230_c().isWood((IBlockAccess)world, event.getPos())) {
            this.chopTree(world, player, event.getPos());
            world.func_184133_a(null, event.getPos(), event.getState().func_177230_c().getSoundType(event.getState(), world, event.getPos(), (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 0.25f, 0.8f);
        }
    }

    private boolean chopTree(World world, EntityPlayer player, BlockPos pos) {
        for (int mod_x = -1; mod_x <= 1; ++mod_x) {
            for (int mod_y = -1; mod_y <= 1; ++mod_y) {
                for (int mod_z = -1; mod_z <= 1; ++mod_z) {
                    BlockPos iterPos = pos.func_177982_a(mod_x, mod_y, mod_z);
                    if (iterPos == pos) continue;
                    if (world.func_180495_p(iterPos).func_177230_c().isWood((IBlockAccess)world, iterPos)) {
                        if (this.canStillChop(player)) {
                            world.func_175655_b(iterPos, true);
                            if (this.chopTree(world, player, iterPos)) continue;
                            return false;
                        }
                        return false;
                    }
                    if (!ModConfig.enchantments.lumberingCutsLeaves || !world.func_180495_p(iterPos).func_177230_c().isLeaves(world.func_180495_p(iterPos), (IBlockAccess)world, iterPos)) continue;
                    world.func_175655_b(iterPos, true);
                    if (this.chopTree(world, player, iterPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean canStillChop(EntityPlayer player) {
        NBTTagCompound comp;
        ItemStack axe = player.func_184614_ca();
        if (axe.func_190926_b()) {
            return false;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().lumbering, (ItemStack)axe) <= 0) {
            return false;
        }
        if (axe.func_77942_o() ? (comp = axe.func_77978_p()).func_74764_b("Energy") && comp.func_74762_e("Energy") <= 0 : (axe.hasCapability(CapabilityEnergy.ENERGY, null) ? ((IEnergyStorage)axe.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() <= 0 : EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().imperishable, (ItemStack)axe) > 0 && axe.func_77958_k() - axe.func_77952_i() <= 1)) {
            return false;
        }
        return !axe.func_96631_a(1, player.func_70681_au(), null);
    }
}

