/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.util;

import com.oitsjustjose.vtweaks.util.ConfigParser;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="vtweaks")
@Mod.EventBusSubscriber
public class ModConfig {
    @Config.Name(value="Enchantments")
    public static Enchantments enchantments = new Enchantments();
    @Config.Name(value="Mob Tweaks")
    public static MobTweaks mobTweaks = new MobTweaks();
    @Config.Name(value="Block Tweaks")
    public static BlockTweaks blockTweaks = new BlockTweaks();
    @Config.Name(value="Item Tweaks")
    public static ItemTweaks itemTweaks = new ItemTweaks();
    @Config.Name(value="Miscellaneous")
    public static Misc misc = new Misc();

    public static void setChallengerLootTable(ArrayList<ItemStack> newList) {
        MobTweaks.ChallengerMobs.challengerLootTable = new ArrayList();
        MobTweaks.ChallengerMobs.challengerLootTable.addAll(newList);
    }

    @Mod.EventBusSubscriber(modid="vtweaks")
    public static class EventHandler {
        @SubscribeEvent
        public void onChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equalsIgnoreCase("vtweaks")) {
                ConfigManager.sync((String)"vtweaks", (Config.Type)Config.Type.INSTANCE);
                ConfigParser.parseItems();
            }
        }
    }

    public static class Misc {
        @Config.Name(value="Enable Horse Armor Recipes")
        @Config.Comment(value={"Allows you to craft horse armor in an anvil"})
        public boolean enableHorseArmorRecipes = true;
        @Config.Name(value="Disable Lightning In Storms")
        @Config.Comment(value={"Prevents glitched lighting as a result of lightning - plus other side-effects"})
        public boolean enableStormTweak = true;
        @Config.Name(value="Enable Death Point Message")
        @Config.Comment(value={"Prints your death point in chat (compatible with JourneyMap)"})
        public boolean enableDeathPoint = true;
        @Config.Name(value="Food Tooltips")
        @Config.Comment(value={"0 disables, 1 shows always, 2 shows with SHIFT"})
        @Config.RangeInt(min=0, max=2)
        public int foodTooltipSetting = 2;
        @Config.Name(value="Durability Tooltips")
        @Config.Comment(value={"0 disables, 1 shows always, 2 shows with SHIFT"})
        @Config.RangeInt(min=0, max=2)
        public int durabilityTooltipSetting = 2;
        @Config.Name(value="Enable Welcome Message")
        @Config.Comment(value={"Shows a welcome message in chat when joining a world for the first time"})
        public boolean enableGuideNotifier = true;
    }

    public static class ItemTweaks {
        @Config.Name(value="Enable Egg Hatching")
        @Config.Comment(value={"Allows egg items to hatch instead of despawn"})
        public boolean enableEggHatching = true;
        @Config.Name(value="Egg Hatching Chance")
        @Config.Comment(value={"One in X chance of an egg hatching, X dictated below:"})
        @Config.RangeInt(min=1)
        public int eggHatchingChance = 256;
        @Config.Name(value="Enable Sapling Self-Planting")
        @Config.Comment(value={"Instead of de-spawning, saplings will attempt to plant themselves"})
        public boolean enableSaplingPlanting = true;
        @Config.Name(value="Adjust Item Despawn Time (in ticks: 20 ticks in a second)")
        @Config.Comment(value={"-1 disables any adjustments"})
        @Config.RangeInt(min=-1)
        public int despawnTimeSetting = -1;
        @Config.Name(value="Convert Concrete Powder to Concrete when the item is thrown into water.")
        public boolean enableConreteTweaks = true;
    }

    public static class BlockTweaks {
        @Config.Name(value="Easy Crop Harvesting")
        @Config.Comment(value={"Allows for right-click-to-harvest on nearly any (including mod) crop"})
        public CropTweak cropTweak = new CropTweak();
        @Config.Name(value="Enable Bone Meal Tweak")
        @Config.Comment(value={"Allows more plants to be bonemealed"})
        public boolean enableBonemealTweak = true;
        @Config.Name(value="Enable Cake Tweak")
        @Config.Comment(value={"Allows you to break cake if it's uneaten!"})
        public boolean enableCakeDrop = true;
        @Config.Name(value="Enable Effective Tool Tweaks")
        @Config.Comment(value={"Fixes some tools NOT being effective on certain materials"})
        public boolean enableToolEffTweaks = true;

        public static class CropTweak {
            @Config.Name(value="Enable Tweak")
            public boolean enableCropTweak = true;
            @Config.Name(value="Blacklisted Crops")
            @Config.Comment(value={"Objects listed here will not be effected by the Easy Crop Harvesting tweak. These are of form <modid:block>, and accepts block wildcards (e.g. <modid:*>)"})
            public String[] blacklist = new String[]{"harvestcraft:*", "resourcefulcrops:*", "actuallyadditions:*"};
        }
    }

    public static class MobTweaks {
        @Config.Name(value="Enable Pet Armory")
        @Config.Comment(value={"Allows you to R-Click your tamed pets with horse armor"})
        public boolean enablePetArmory = true;
        @Config.Name(value="Drop Buffs")
        public DropBuffs dropBuffs = new DropBuffs();
        @Config.Name(value="Enable \"glue\" drops")
        @Config.Comment(value={"Changes horse drops under \"hot\" conditions"})
        public boolean enableHorseGlue = true;
        @Config.Name(value="Enable Feather Plucking")
        @Config.Comment(value={"Allows chicken feathers to be plucked w/ shears"})
        public boolean enableFeatherPlucking = true;
        @Config.Name(value="Sheep Dye Fix")
        public SheepDyeFix sheepDyeFix = new SheepDyeFix();
        @Config.Name(value="Challenger Mobs")
        public ChallengerMobs challengerMobs = new ChallengerMobs();
        @Config.Name(value="Peaceful Surface")
        public PeacefulSurface peacefulSurface = new PeacefulSurface();

        public static class PeacefulSurface {
            @Config.Name(value="Peaceful Surface")
            @Config.Comment(value={"Prevents enemies on the surface, except for nights of a new moon"})
            public boolean enabled = true;
            @Config.Name(value="Minimum Y for Peaceful Surface feature")
            @Config.Comment(value={"If Peaceful Surface is enabled, enemies can spawn below this Y-level:"})
            public int minY = 64;
            @Config.Name(value="Peaceful Surface Dimension Blacklist")
            public int[] blacklist = new int[]{-1, 1, 7};
        }

        public static class ChallengerMobs {
            public static ArrayList<ItemStack> challengerLootTable = new ArrayList();
            @Config.Name(value="Enable Tweak")
            @Config.Comment(value={"Randomly spawns more difficult (but more lootworthy) enemies Applies to ALL enemies"})
            public boolean enabled = true;
            @Config.Name(value="Rarity")
            public int chance = 100;
            @Config.Name(value="Custom Names")
            @Config.Comment(value={"Enabling this will add custom names (like name-tags) to challenger mobs"})
            public boolean customNames = true;
            @Config.Name(value="Loot Table")
            @Config.Comment(value={"Loot table. Formatted as:\n    <modid>:<item>,\n    <modid>:<item>*<quantity>,\n    <modid>:<item>:<meta>, or\n    <modid>:<item>:<meta>*<quantity>"})
            public String[] loot = new String[]{"minecraft:gold_ingot", "minecraft:gold_nugget*15", "minecraft:diamond", "minecraft:emerald", "minecraft:ghast_tear", "minecraft:ender_pearl", "minecraft:emerald", "minecraft:experience_bottle"};
            @Config.Name(value="Entity Blacklist")
            @Config.Comment(value={"The class name (or part of it) of any entities that should not be turned to challenger mobs"})
            public String[] blacklist = new String[0];
        }

        public static class SheepDyeFix {
            @Config.Name(value="Enable Tweak")
            @Config.Comment(value={"Allows sheep to be dyed with any oreDict dye"})
            public boolean enabled = true;
            @Config.Name(value="Blacklisted Dyes")
            @Config.Comment(value={"The class name (or part of it) of the dye you don't want to work with the Sheep Dye Fix"})
            public String[] blacklist = new String[]{"net.minecraft.item.ItemDye", "biomesoplenty"};
        }

        public static class DropBuffs {
            @Config.Name(value="Chicken Feathers")
            public boolean chickenFeathers = true;
            @Config.Name(value="Cow Leather")
            public boolean cowLeather = true;
            @Config.Name(value="Skeleton Bones")
            public boolean skeletonBones = true;
            @Config.Name(value="Squid Ink Sacs")
            public boolean squidSacs = true;
            @Config.Name(value="Enderman Ender Pearls")
            public boolean enderPearls = true;
        }
    }

    public static class Enchantments {
        @Config.Name(value="Enable Lumbering")
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable the Lumbering enchantment for Axes"})
        public boolean enableLumbering = true;
        @Config.Name(value="Enable Imperishable")
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable the Imperishable enchantment for any breakable item"})
        public boolean enableImperishable = true;
        @Config.Name(value="Enable Feather Falling Tweak")
        @Config.Comment(value={"Feather Falling IV or above directs 100% of fall damage to boots"})
        public boolean enableFeatherFallTweak = true;
        @Config.Name(value="Lumbering Recipe XP Cost")
        @Config.RangeInt(min=1, max=40)
        @Config.Comment(value={"Number of levels Lumbering costs to create in an anvil"})
        public int lumberingCost = 16;
        @Config.Name(value="Lumbering Cuts Leaves")
        @Config.Comment(value={"True makes it so lumbering a tree cuts leaves, false doesn't"})
        public boolean lumberingCutsLeaves = true;
    }
}

