/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.util.Prep;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class SetRandomDarkUpgrade
extends LootFunction {
    public SetRandomDarkUpgrade(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public ItemStack func_186553_a(@Nonnull ItemStack stack, @Nonnull Random rand, @Nonnull LootContext context) {
        if (Prep.isValid(stack) && stack.func_77973_b() instanceof IDarkSteelItem) {
            Predicate<IRule> checker = Rules.makeChecker(stack, (IDarkSteelItem)stack.func_77973_b());
            List list = UpgradeRegistry.getUpgrades().stream().filter(upgrade -> upgrade.getRules().stream().filter(Rules::isStatic).allMatch(checker)).collect(Collectors.toList());
            if (!list.isEmpty()) {
                int maxCount = rand.nextInt(4) + 2;
                int count = 0;
                int tries = list.size() * maxCount;
                stack = stack.func_77946_l();
                int nextInt = rand.nextInt(list.size());
                while (count < maxCount && tries-- > 0) {
                    IDarkSteelUpgrade upgrade2 = (IDarkSteelUpgrade)list.get(nextInt);
                    if (upgrade2.canAddToItem(stack, (IDarkSteelItem)stack.func_77973_b())) {
                        upgrade2.addToItem(stack, (IDarkSteelItem)stack.func_77973_b());
                        ++count;
                        nextInt = rand.nextInt(list.size());
                        continue;
                    }
                    if (nextInt == 0) {
                        nextInt = list.size() - 1;
                        continue;
                    }
                    --nextInt;
                }
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetRandomDarkUpgrade> {
        protected Serializer() {
            super(new ResourceLocation("enderio", "set_random_dark_upgrade"), SetRandomDarkUpgrade.class);
        }

        public void serialize(@Nonnull JsonObject object, @Nonnull SetRandomDarkUpgrade functionClazz, @Nonnull JsonSerializationContext serializationContext) {
        }

        @Nonnull
        public SetRandomDarkUpgrade deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull LootCondition[] conditionsIn) {
            return new SetRandomDarkUpgrade(conditionsIn);
        }
    }
}

