/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.modes;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketIoMode
extends MessageTileEntity<TileEntity> {
    IoMode mode;
    EnumFacing face;

    public PacketIoMode() {
    }

    public <E extends TileEntity> PacketIoMode(@Nonnull E cont) {
        super(cont);
        this.mode = IoMode.NONE;
        this.face = null;
    }

    public <E extends TileEntity> PacketIoMode(@Nonnull E cont, EnumFacing face) {
        super(cont);
        this.face = face;
        this.mode = ((IIoConfigurable)cont).getIoMode(face);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort((int)((short)this.mode.ordinal()));
        if (this.face != null) {
            buf.writeShort((int)((short)this.face.ordinal()));
        } else {
            buf.writeShort(-1);
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.mode = IoMode.values()[buf.readShort()];
        short ord = buf.readShort();
        this.face = ord < 0 ? null : EnumFacing.values()[ord];
    }

    public static class Handler
    implements IMessageHandler<PacketIoMode, IMessage> {
        public IMessage onMessage(PacketIoMode message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity te = message.getTileEntity(player.field_70170_p);
            if (te instanceof IIoConfigurable) {
                IIoConfigurable me = (IIoConfigurable)te;
                if (message.face == null) {
                    me.clearAllIoModes();
                } else {
                    me.setIoMode(message.face, message.mode);
                }
            }
            return null;
        }
    }
}

