/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.network;

import crazypants.enderio.base.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enderio")
public class ExecPacket
implements IMessage {
    private static IForgeRegistry<IServerExec> REGISTRY = null;
    private IServerExec remoteExec;
    private Consumer<ByteBuf> writer;
    private Consumer<EntityPlayerMP> runner;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("enderio", "remoteexec")).setType(IServerExec.class).setIDRange(0, Short.MAX_VALUE).create();
    }

    public static void send(IServerExec remoteExec, Consumer<ByteBuf> writer) {
        if (writer != null && remoteExec != null && REGISTRY != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new ExecPacket(remoteExec, writer));
        }
    }

    public ExecPacket(@Nonnull IServerExec remoteExec, @Nonnull Consumer<ByteBuf> writer) {
        this.remoteExec = remoteExec;
        this.writer = writer;
    }

    public ExecPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        if (buf != null && REGISTRY != null) {
            this.remoteExec = (IServerExec)ByteBufUtils.readRegistryEntry((ByteBuf)buf, REGISTRY);
            this.runner = (Consumer)this.remoteExec.apply(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        if (buf != null && this.remoteExec != null) {
            ByteBufUtils.writeRegistryEntry((ByteBuf)buf, (IForgeRegistryEntry)this.remoteExec);
            this.writer.accept(buf);
        }
    }

    public static class Handler
    implements IMessageHandler<ExecPacket, IMessage> {
        public IMessage onMessage(ExecPacket message, MessageContext ctx) {
            if (message.remoteExec != null && message.runner != null) {
                message.runner.accept(ctx.getServerHandler().field_147369_b);
            }
            return null;
        }
    }

    public static interface IServerExec
    extends IForgeRegistryEntry<IServerExec>,
    Function<ByteBuf, Consumer<EntityPlayerMP>> {
    }
}

