/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.machine.wired.ContainerWiredCharger;
import crazypants.enderio.machines.machine.wired.GuiWiredCharger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public class WiredChargerRecipeCategory
extends BlankRecipeCategory<WiredChargerRecipeWrapper> {
    @Nonnull
    public static final String UID = "EIOWC";
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated flame;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableWiredChargerJEIRecipes.get()).booleanValue()) {
            return;
        }
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new WiredChargerRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_wired_charger.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_normal_wireless_charger.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiWiredCharger.class, 176, 42, 16, 16, new String[]{UID});
        long start = System.nanoTime();
        List validItems = MachinesPlugin.iModRegistry.getIngredientRegistry().getIngredients(ItemStack.class);
        final ArrayList result = new ArrayList();
        ContainerWiredCharger.getValidPair(validItems).apply((NNList.Callback)new NNList.Callback<Triple<ItemStack, ItemStack, Integer>>(){

            public void apply(@Nonnull Triple<ItemStack, ItemStack, Integer> e) {
                result.add(new WiredChargerRecipeWrapper((ItemStack)e.getLeft(), (ItemStack)e.getMiddle(), (Integer)e.getRight()));
            }
        });
        long end = System.nanoTime();
        MachinesPlugin.iModRegistry.addRecipes(result, UID);
        MachinesPlugin.iModRegistry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerWiredCharger.class, UID, ContainerWiredCharger.FIRST_RECIPE_SLOT, ContainerWiredCharger.NUM_RECIPE_SLOT, ContainerWiredCharger.FIRST_INVENTORY_SLOT, ContainerWiredCharger.NUM_INVENTORY_SLOT);
        Log.info(String.format("WiredChargerRecipeCategory: Added %d item charging recipes to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9));
    }

    public WiredChargerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("wired_charger");
        this.background = guiHelper.createDrawable(backgroundLocation, 49, 15, 100, 49, 0, 0, 46, 0);
        this.flame = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(backgroundLocation, 241, 0, 14, 37), 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_wired_charger.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 99, 2);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull WiredChargerRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 71, 12);
        guiItemStacks.init(1, false, 122, 12);
        group.init(2, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 0, 16, 70, 10, 0, 0);
        guiItemStacks.set(ingredients);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class WiredChargerRecipeWrapper
    extends BlankRecipeWrapper {
        @Nonnull
        private final ItemStack itemInput;
        @Nonnull
        private final ItemStack itemOutput;
        @Nonnull
        private final EnergyIngredient energy;

        public WiredChargerRecipeWrapper(@Nonnull ItemStack itemInput, @Nonnull ItemStack itemOutput, int energy) {
            this.itemInput = itemInput;
            this.itemOutput = itemOutput;
            this.energy = new EnergyIngredient(energy);
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.itemInput);
            ingredients.setOutput(ItemStack.class, (Object)this.itemOutput);
            ingredients.setInput(EnergyIngredient.class, (Object)this.energy);
        }
    }
}

