/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vacuum.chest;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.machines.machine.vacuum.chest.TileVacuumChest;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVaccumChest
extends MessageTileEntity<TileVacuumChest> {
    public static final int CMD_SET_RANGE = 0;
    public static final int CMD_SET_SLOT = 1;
    public static final int CMD_SET_BLACKLIST = 2;
    public static final int CMD_SET_MATCHMETA = 3;
    private int cmd;
    private int value;
    @Nonnull
    private ItemStack stack = ItemStack.field_190927_a;

    public PacketVaccumChest() {
    }

    private PacketVaccumChest(@Nonnull TileVacuumChest tile, int cmd) {
        super((TileEntity)tile);
        this.cmd = cmd;
    }

    public static PacketVaccumChest setRange(@Nonnull TileVacuumChest tile, int range) {
        PacketVaccumChest msg = new PacketVaccumChest(tile, 0);
        msg.value = range;
        tile.setRange(range);
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.cmd = buf.readByte() & 0xFF;
        this.value = buf.readInt();
        this.stack = (ItemStack)NullHelper.notnullF((Object)ByteBufUtils.readItemStack((ByteBuf)buf), (String)"readItemStack returned null");
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.cmd);
        buf.writeInt(this.value);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<PacketVaccumChest, IMessage> {
        @Nullable
        public IMessage onMessage(PacketVaccumChest msg, MessageContext ctx) {
            TileVacuumChest te = (TileVacuumChest)msg.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
            if (te != null) {
                switch (msg.cmd) {
                    case 0: {
                        te.setRange(msg.value);
                    }
                }
            }
            return null;
        }
    }
}

